/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.AbstractFlowGroup;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.DeliverCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.DeliverFlowGroup;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.FlowCmd;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.WorkspaceComponentGrouping;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ChangeSetAlreadyInHistoryException;
import com.ibm.team.scm.common.DeliveryIntroducesConflictsException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.OutstandingConflictsException;
import com.ibm.team.scm.common.SyncReportInappropriateException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliverCmd
extends FlowCmd {
    @Override
    protected List<AbstractFlowGroup> findFlows(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        List componentSelectors = null;
        if (subargs.hasOption((IOptionKey)DeliverCmdOptions.OPT_MODE_COMPONENTS) && ((componentSelectors = subargs.getOptions((IOptionKey)DeliverCmdOptions.OPT_MODE_COMPONENTS)) == null || componentSelectors.size() == 0)) {
            throw StatusHelper.argSyntax((String)Messages.DeliverCmd_COMPONENTS_SELECTOR_NO_ARGS);
        }
        Collection<WorkspaceComponentGrouping> subject = this.findSubject(config, subargs.getOption(CommonOptions.OPT_STREAM_SOURCE_SELECTOR, null));
        if (subargs.hasOption((IOptionKey)DeliverCmdOptions.OPT_MODE_COMPONENTS)) {
            this.filterComponents(componentSelectors, subject, config);
        }
        List<AbstractFlowGroup> toFlow = this.findCollaboration(subject, subargs.getOption(CommonOptions.OPT_STREAM_TARGET_SELECTOR, null), config);
        return toFlow;
    }

    private void filterComponents(List<String> componentSelectors, Collection<WorkspaceComponentGrouping> subject, IClientConfiguration config) throws FileSystemClientException {
        HashMap<String, UUID> componentHandleToUUID = new HashMap<String, UUID>();
        for (String componentSelector : componentSelectors) {
            componentHandleToUUID.put(componentSelector, RepoUtil.lookupUuid((String)componentSelector));
        }
        ArrayList<String> componentsMatched = new ArrayList<String>();
        List<String> properties = Arrays.asList(IComponent.ITEM_ID_PROPERTY, IComponent.NAME_PROPERTY);
        for (WorkspaceComponentGrouping wsComp : subject) {
            List components;
            IItemManager itemManager = wsComp.getWorkspaceConnection().teamRepository().itemManager();
            try {
                components = itemManager.fetchPartialItems(new ArrayList(wsComp.getComponents()), 0, properties, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.DeliverCmd_ERROR_FETCHING_COMPONENTS, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            block4: for (IComponent component : components) {
                if (componentHandleToUUID.values().contains(component.getItemId())) {
                    for (Map.Entry entry : componentHandleToUUID.entrySet()) {
                        if (!component.getItemId().equals(entry.getValue())) continue;
                        componentsMatched.add((String)entry.getKey());
                        continue block4;
                    }
                    continue;
                }
                if (componentSelectors.contains(component.getName())) {
                    if (componentsMatched.contains(component.getName())) {
                        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DeliverCmd_AMBIGUOUS_COMPONENT_SELECTOR, (Object)component.getName()));
                    }
                    componentsMatched.add(component.getName());
                    continue;
                }
                for (IComponentHandle componentHandle : wsComp.getComponents()) {
                    if (!componentHandle.getItemId().equals((Object)component.getItemHandle().getItemId())) continue;
                    wsComp.getComponents().remove(componentHandle);
                    continue block4;
                }
            }
        }
        if (componentSelectors.size() != componentsMatched.size()) {
            ArrayList<String> componentsUnMatched = new ArrayList<String>();
            for (String componentSelector : componentSelectors) {
                if (componentsMatched.contains(componentSelector)) continue;
                componentsUnMatched.add(componentSelector);
            }
            if (componentsUnMatched.size() > 0) {
                IndentingPrintStream err = new IndentingPrintStream((OutputStream)config.getContext().stderr());
                err.println((CharSequence)Messages.DeliverCmd_UNRESOLVED_COMPONENT_SELECTOR_LIST);
                err = err.indent();
                for (String componentSelector : componentsUnMatched) {
                    err.println((CharSequence)componentSelector);
                }
                throw StatusHelper.ambiguousSelector((String)Messages.DeliverCmd_UNRESOLVED_COMPONENT_SELECTOR_MESSAGE);
            }
        }
    }

    @Override
    protected IOptionKey getFlowSourceOptKey() {
        return CommonOptions.OPT_STREAM_SOURCE_SELECTOR;
    }

    @Override
    protected IWorkspaceHandle findCollaboration(IWorkspaceConnection wsConn, IFlowTable flowTable, IComponentHandle component) {
        IFlowEntry entry = flowTable.getCurrentDeliverFlow(component);
        if (entry == null) {
            entry = flowTable.getCurrentDeliverFlow();
        }
        if (entry == null) {
            entry = flowTable.getDefaultDeliverFlow();
        }
        if (entry == null) {
            return null;
        }
        return (IWorkspaceHandle)entry.getFlowNode();
    }

    @Override
    protected IWorkspaceHandle findTargetWorkspace(IWorkspaceConnection wsConn, IFlowTable flowTable) throws FileSystemClientException {
        IFlowEntry entry = flowTable.getCurrentDeliverFlow();
        if (entry == null) {
            entry = flowTable.getDefaultDeliverFlow();
        }
        if (entry == null) {
            return null;
        }
        return (IWorkspaceHandle)entry.getFlowNode();
    }

    @Override
    protected void flow(List<AbstractFlowGroup> toFlow, IClientConfiguration config) throws FileSystemClientException {
        if (config.isDryRun()) {
            return;
        }
        for (AbstractFlowGroup flow : toFlow) {
            this.flow(flow, config);
        }
    }

    protected void flow(AbstractFlowGroup flow, IClientConfiguration config) throws FileSystemClientException {
        try {
            flow.getSubject().deliver(flow.getTarget(), flow.syncReport, flow.getNewBasis(), flow.getChangesToFlow(), null);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw StatusHelper.ambiguousSelector((String)Messages.DeliverCmd_0);
        }
        catch (StaleDataException staleDataException) {
            throw StatusHelper.staleData((String)Messages.DeliverCmd_1);
        }
        catch (DeliveryIntroducesConflictsException deliveryIntroducesConflictsException) {
            throw StatusHelper.conflict((String)Messages.DeliverCmd_2);
        }
        catch (SyncReportInappropriateException e) {
            throw StatusHelper.failure((String)Messages.DeliverCmd_3, (Throwable)e);
        }
        catch (OutstandingConflictsException outstandingConflictsException) {
            throw StatusHelper.conflict((String)Messages.DeliverCmd_4);
        }
        catch (GapException gapException) {
            throw StatusHelper.gap((String)Messages.DeliverCmd_5);
        }
        catch (ChangeSetAlreadyInHistoryException changeSetAlreadyInHistoryException) {
            throw StatusHelper.argSyntax((String)Messages.DeliverCmd_6);
        }
        catch (TeamOperationCanceledException e) {
            throw StatusHelper.processFailure((String)Messages.DeliverCmd_7, (TeamOperationCanceledException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        catch (TeamRepositoryException e) {
            if (this.hasMismatchedComponents(flow.syncReport)) {
                throw StatusHelper.disallowed((String)Messages.AcceptCmd_19);
            }
            throw StatusHelper.wrap((String)Messages.DeliverCmd_8, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
    }

    @Override
    protected AbstractFlowGroup createFlowGroup(IWorkspaceConnection start, List<IComponentHandle> componentsToFlow, IWorkspaceConnection collab) {
        return new DeliverFlowGroup(start, componentsToFlow, collab);
    }

    @Override
    protected String findFlowDescription(AbstractFlowGroup flow) {
        return NLS.bind((String)Messages.DeliverCmd_9, (Object)flow.getSource().getName(), (Object)flow.getTarget().getName());
    }
}

