/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.IChangeDescription;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.IBasicChange;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeDisplayer {
    static final char FLAG_STRUCT_ADD = 'a';
    static final char FLAG_STRUCT_DELETE = 'd';
    static final char FLAG_STRUCT_MOVE = 'v';
    static final char FLAG_STRUCT_RENAME = 'r';
    static final char FLAG_STRUCT_NONE = '-';
    static final char FLAG_CONTENT_MODIFY = 'm';
    static final char FLAG_CONTENT_NONE = '-';
    static final char FLAG_PROPS_MODIFIED = 'p';
    static final char FLAG_PROPS_NONE = '-';
    static final char FLAG_CONFLICT_COLLISION = 'c';
    static final char FLAG_CONFLICT_AUTOMERGE = 'A';
    static final char FLAG_CONFLICT_CONFLICTED = 'C';
    static final char FLAG_CONFLICT_INCIDENTAL = 'I';
    static final char FLAG_CONFLICT_NONE = '-';

    public static void showChanges(ISandbox sandbox, IWorkspaceConnection wsConn, List<IChangeSetHandle> changes, boolean verbose, boolean quiet, IndentingPrintStream labelOut, IClientConfiguration config) throws FileSystemClientException {
        List fullComps;
        if (quiet) {
            return;
        }
        if (changes.size() == 0 && verbose) {
            labelOut.println((CharSequence)Messages.ChangeDisplayer_1);
            return;
        }
        labelOut.println((CharSequence)Messages.ChangeDisplayer_2);
        IndentingPrintStream out = labelOut.indent();
        ArrayList<String> props = new ArrayList<String>(3);
        props.add(IChangeSet.COMMENT_PROPERTY);
        props.add(IChangeSet.CHANGES_PROPERTY);
        props.add(IChangeSet.COMPONENT_PROPERTY);
        IItemManager itemMgr = wsConn.teamRepository().itemManager();
        try {
            itemMgr.fetchPartialItems(changes, 0, props, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangeDisplayer_4, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        Map grouped = RepoUtil.groupChangeSetsByComponent((IWorkspaceConnection)wsConn, changes, (IClientConfiguration)config);
        List comps = ItemLists.idsToHandles(grouped.keySet());
        try {
            fullComps = itemMgr.fetchPartialItems(comps, 0, Collections.singletonList(IComponent.NAME_PROPERTY), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangeDisplayer_6, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        for (IComponent comp : fullComps) {
            IConfiguration configuration;
            try {
                configuration = wsConn.configuration((IComponentHandle)comp);
            }
            catch (ItemNotFoundException e) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ChangeDisplayer_7, (Object)comp.getItemId().getUuidValue()), (Throwable)e);
            }
            catch (ComponentNotInWorkspaceException e) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ChangeDisplayer_8, (Object)comp.getItemId().getUuidValue()), (Throwable)e);
            }
            Map<ItemId<IChangeSet>, SortedSet<IChangeDescription>> cs2changes = ChangeDisplayer.describeChangeSets(wsConn, sandbox, configuration, changes, ChangeDescriptionComparator.instance, config);
            out.println((CharSequence)NLS.bind((String)Messages.ChangeDisplayer_9, (Object)comp.getName()));
            IndentingPrintStream csOut = out.indent();
            for (Map.Entry<ItemId<IChangeSet>, SortedSet<IChangeDescription>> entry : cs2changes.entrySet()) {
                IChangeSet cs;
                try {
                    cs = (IChangeSet)itemMgr.fetchPartialItem(entry.getKey().toHandle(), 0, props, null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.ChangeDisplayer_10, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
                csOut.println((CharSequence)AliasUtil.alias((UUID)cs.getItemId()));
                ChangeDisplayer.showChanges(cs2changes.get(new ItemId((IItemHandle)cs)), csOut.indent());
            }
        }
    }

    public static void showChanges(SortedSet<IChangeDescription> changes, IndentingPrintStream out) {
        for (IChangeDescription desc : changes) {
            out.printIndent();
            out.print((CharSequence)ChangeDisplayer.computeChangeLetters(desc));
            out.print((CharSequence)" ");
            out.print((CharSequence)desc.getCurrentPath());
            out.println();
        }
    }

    public static void showConflicts(IWorkspaceConnection wsConn, IndentingPrintStream out, IClientConfiguration config) throws FileSystemClientException {
        ILogicalConflictReport report;
        IFileSystemView fsv = FileSystemCore.getFileSystemManager((ITeamRepository)wsConn.teamRepository()).getFileSystemView((IConnection)wsConn);
        try {
            report = fsv.conflictReport(null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangeDisplayer_14, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        TreeSet<IChangeDescription> conflicts = new TreeSet<IChangeDescription>(ChangeDescriptionComparator.instance);
        for (ILogicalConflict conflict : report.conflicts()) {
            conflicts.add(new ChangeDescription((IChangeSummary)conflict));
        }
        TreeSet<IChangeDescription> incidental = new TreeSet<IChangeDescription>(ChangeDescriptionComparator.instance);
        for (ILogicalChange change : report.incidentalChanges()) {
            incidental.add(new ChangeDescription((IChangeSummary)change));
        }
        TreeSet<IChangeDescription> auto = new TreeSet<IChangeDescription>(ChangeDescriptionComparator.instance);
        for (ILogicalChange change : report.autoMergeChanges()) {
            auto.add(new ChangeDescription((IChangeSummary)change));
        }
        if (conflicts.size() > 0 || incidental.size() > 0 || auto.size() > 0) {
            out.println((CharSequence)Messages.ChangeDisplayer_13);
            out = out.indent();
            ChangeDisplayer.showChanges(conflicts, out);
            ChangeDisplayer.showChanges(incidental, out);
            ChangeDisplayer.showChanges(auto, out);
        } else {
            out.println((CharSequence)Messages.ChangeDisplayer_NO_CONFLICTS_MSG);
        }
    }

    public static Map<ItemId<IChangeSet>, SortedSet<IChangeDescription>> describeChangeSets(IWorkspaceConnection wsConn, ISandbox sandbox, IConfiguration configuration, List<IChangeSetHandle> csHandles, Comparator<IChangeDescription> comparator, IClientConfiguration config) throws FileSystemClientException {
        List cses;
        try {
            cses = wsConn.teamRepository().itemManager().fetchPartialItems(csHandles, 0, Collections.singletonList(IChangeSet.CHANGES_PROPERTY), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangeDisplayer_16, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        IComponentHandle component = configuration.component();
        HashMap<Object, IPath> paths = new HashMap<Object, IPath>();
        LinkedList<StateId<IVersionable>> toQuery = new LinkedList<StateId<IVersionable>>();
        for (IChangeSet cs : cses) {
            List changes = cs.changes();
            for (IChange change : changes) {
                StateId<IVersionable> id = ChangeDisplayer.createStateFor(change);
                IShareable shareable = null;
                if (sandbox != null) {
                    shareable = sandbox.findShareable(wsConn.getContextHandle(), component, change.item(), null);
                }
                if (shareable == null) {
                    toQuery.add(id);
                    continue;
                }
                paths.put(id, shareable.getLocalPath());
            }
        }
        if (toQuery.size() > 0) {
            List ancestors;
            try {
                ancestors = configuration.determineAncestorsInHistory(ItemLists.statesToHandles(toQuery), null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ChangeDisplayer_17, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            assert (ancestors.size() == toQuery.size());
            Iterator toQueryIterator = toQuery.iterator();
            Iterator ancestorIterator = ancestors.iterator();
            while (toQueryIterator.hasNext()) {
                StateId v = (StateId)toQueryIterator.next();
                IAncestorReport rep = (IAncestorReport)ancestorIterator.next();
                paths.put(v, ChangeDisplayer.ancestorReportToPath(rep));
            }
        }
        HashMap<ItemId<IChangeSet>, SortedSet<IChangeDescription>> cs2descs = new HashMap<ItemId<IChangeSet>, SortedSet<IChangeDescription>>();
        for (IChangeSet cs : cses) {
            List changes = cs.changes();
            TreeSet<IChangeDescription> descs = new TreeSet<IChangeDescription>(comparator);
            for (IChange change : changes) {
                descs.add(new CSChangeDescription(change, (IPath)paths.get(ChangeDisplayer.createStateFor(change))));
            }
            cs2descs.put((ItemId<IChangeSet>)new ItemId((IItemHandle)cs), descs);
        }
        return cs2descs;
    }

    private static StateId<IVersionable> createStateFor(IChange change) {
        IVersionableHandle state = change.afterState();
        if (state == null || state.getStateId() == null) {
            state = change.beforeState();
        }
        return new StateId((IItemHandle)state);
    }

    private static IPath ancestorReportToPath(IAncestorReport report) {
        StringBuffer buf = new StringBuffer("/");
        for (INameItemPair pair : report.getNameItemPairs()) {
            if (pair.getName() == null) continue;
            buf.append(pair.getName());
        }
        return new Path(buf.toString());
    }

    private static boolean isRename(IPath currentPath, IPath destPath) {
        if (destPath == null) {
            return false;
        }
        int len = destPath.segmentCount();
        return len == currentPath.segmentCount() && destPath.uptoSegment(len - 1).equals((Object)currentPath.uptoSegment(len - 1));
    }

    protected static String getConflictInformation(ILogicalChange logicalChange, boolean mine, boolean html) {
        if (logicalChange.kind() == 1) {
            ILogicalConflict conflict = (ILogicalConflict)logicalChange;
            switch (conflict.conflictType()) {
                case 1: {
                    return Messages.ChangeDisplayer_20;
                }
                case 2: {
                    return mine ? Messages.ChangeDisplayer_21 : Messages.ChangeDisplayer_22;
                }
                case 3: {
                    return mine ? Messages.ChangeDisplayer_23 : Messages.ChangeDisplayer_24;
                }
                case 5: {
                    return mine ? Messages.ChangeDisplayer_25 : Messages.ChangeDisplayer_26;
                }
                case 4: {
                    return mine ? Messages.ChangeDisplayer_27 : Messages.ChangeDisplayer_28;
                }
                case 10: {
                    return mine ? Messages.ChangeDisplayer_29 : Messages.ChangeDisplayer_30;
                }
                case 9: {
                    return Messages.ChangeDisplayer_31;
                }
                case 7: {
                    return mine ? Messages.ChangeDisplayer_32 : Messages.ChangeDisplayer_33;
                }
                case 8: {
                    return mine ? Messages.ChangeDisplayer_34 : Messages.ChangeDisplayer_35;
                }
                case 6: {
                    return Messages.ChangeDisplayer_36;
                }
            }
            return Messages.ChangeDisplayer_37;
        }
        if (logicalChange.kind() == 2) {
            if (logicalChange.isChangeType(1)) {
                return mine ? Messages.ChangeDisplayer_38 : Messages.ChangeDisplayer_39;
            }
            if (logicalChange.isChangeType(2)) {
                return mine ? Messages.ChangeDisplayer_40 : Messages.ChangeDisplayer_41;
            }
            if (logicalChange.isChangeType(12)) {
                return mine ? Messages.ChangeDisplayer_42 : Messages.ChangeDisplayer_43;
            }
            if (logicalChange.isChangeType(4)) {
                return Messages.ChangeDisplayer_44;
            }
            if (logicalChange.isChangeType(8)) {
                return mine ? Messages.ChangeDisplayer_45 : Messages.ChangeDisplayer_46;
            }
            if (logicalChange.isChangeType(16)) {
                return Messages.ChangeDisplayer_47;
            }
            return mine ? Messages.ChangeDisplayer_48 : Messages.ChangeDisplayer_49;
        }
        if (logicalChange.kind() == 3) {
            if (logicalChange.isChangeType(1)) {
                return mine ? Messages.ChangeDisplayer_50 : Messages.ChangeDisplayer_51;
            }
            if (logicalChange.isChangeType(2)) {
                return mine ? Messages.ChangeDisplayer_52 : Messages.ChangeDisplayer_53;
            }
            if (logicalChange.isChangeType(12)) {
                return mine ? Messages.ChangeDisplayer_54 : Messages.ChangeDisplayer_55;
            }
            if (logicalChange.isChangeType(4)) {
                return mine ? Messages.ChangeDisplayer_56 : Messages.ChangeDisplayer_57;
            }
            if (logicalChange.isChangeType(8)) {
                return mine ? Messages.ChangeDisplayer_58 : Messages.ChangeDisplayer_59;
            }
            if (logicalChange.isChangeType(16)) {
                return mine ? Messages.ChangeDisplayer_60 : Messages.ChangeDisplayer_61;
            }
            return mine ? Messages.ChangeDisplayer_62 : Messages.ChangeDisplayer_63;
        }
        return Messages.ChangeDisplayer_64;
    }

    private static IPath getLocalPathFor(String[] path) {
        if (path == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < path.length) {
            buffer.append('/').append(path[i]);
            ++i;
        }
        return new Path(buffer.toString());
    }

    public static String computeDescription(IChangeDescription change) {
        return change.computeDescription();
    }

    public static String computeChangeLetters(IChangeDescription change) {
        char[] flags = new char[4];
        switch (change.getConflictType()) {
            case AUTOMERGE: {
                flags[0] = 65;
                break;
            }
            case CONFLICTED: {
                flags[0] = 67;
                break;
            }
            case INCIDENTAL: {
                flags[0] = 73;
                break;
            }
            case NONE: {
                flags[0] = 45;
            }
        }
        switch (change.getStructuralChange()) {
            case ADD: {
                flags[1] = 97;
                break;
            }
            case DELETE: {
                flags[1] = 100;
                break;
            }
            case MOVE: {
                flags[1] = 118;
                break;
            }
            case RENAME: {
                flags[1] = 114;
                break;
            }
            case NONE: {
                flags[1] = 45;
            }
        }
        switch (change.getContentChange()) {
            case MODIFIED: {
                flags[2] = 109;
                break;
            }
            case NONE: {
                flags[2] = 45;
            }
        }
        switch (change.getPropertyChange()) {
            case MODIFIED: {
                flags[3] = 112;
                break;
            }
            case NONE: {
                flags[3] = 45;
            }
        }
        return new String(flags);
    }

    private static class CSChangeDescription
    implements IChangeDescription {
        private final IChange change;
        private final IPath path;

        public CSChangeDescription(IChange change, IPath path) {
            this.change = change;
            this.path = path;
        }

        public String computeDescription() {
            return null;
        }

        public IChangeDescription.ConflictType getConflictType() {
            return IChangeDescription.ConflictType.NONE;
        }

        public IChangeDescription.ContentChange getContentChange() {
            if ((this.change.kind() & 2) != 0) {
                return IChangeDescription.ContentChange.MODIFIED;
            }
            return IChangeDescription.ContentChange.NONE;
        }

        public String getCurrentPath() {
            return this.path.toString();
        }

        public IChangeDescription.PropertyChange getPropertyChange() {
            return IChangeDescription.PropertyChange.NONE;
        }

        public IChangeDescription.StructuralChange getStructuralChange() {
            if (this.change.kind() == 1) {
                return IChangeDescription.StructuralChange.ADD;
            }
            if (this.change.kind() == 16) {
                return IChangeDescription.StructuralChange.DELETE;
            }
            if ((this.change.kind() & 4) != 0) {
                return IChangeDescription.StructuralChange.RENAME;
            }
            if ((this.change.kind() & 8) != 0) {
                return IChangeDescription.StructuralChange.MOVE;
            }
            return IChangeDescription.StructuralChange.NONE;
        }
    }

    public static class ChangeDescription
    implements IChangeDescription {
        final IPath currentPath;
        final IPath prevPath;
        final boolean isRename;
        final IBasicChange change;
        String desc;

        public ChangeDescription(IChangeSummary summary) {
            this.change = summary;
            if (summary.isChangeType(8)) {
                this.prevPath = ChangeDisplayer.getLocalPathFor(summary.getPathHint());
                this.currentPath = ChangeDisplayer.getLocalPathFor(summary.getNewPathHint());
                this.isRename = ChangeDisplayer.isRename(this.prevPath, this.currentPath);
            } else {
                this.prevPath = null;
                this.currentPath = ChangeDisplayer.getLocalPathFor(summary.getPathHint());
                this.isRename = false;
            }
        }

        public String getCurrentPath() {
            return this.currentPath.toString();
        }

        public IChangeDescription.ConflictType getConflictType() {
            if (!(this.change instanceof ILogicalConflict)) {
                return IChangeDescription.ConflictType.NONE;
            }
            ILogicalConflict conflict = (ILogicalConflict)this.change;
            switch (conflict.kind()) {
                case 2: {
                    return IChangeDescription.ConflictType.AUTOMERGE;
                }
                case 1: {
                    return IChangeDescription.ConflictType.CONFLICTED;
                }
                case 3: {
                    return IChangeDescription.ConflictType.INCIDENTAL;
                }
            }
            throw new RuntimeException(NLS.bind((String)Messages.ChangeDisplayer_19, (Object)conflict.kind()));
        }

        public IChangeDescription.ContentChange getContentChange() {
            if (this.change.isChangeType(4)) {
                return IChangeDescription.ContentChange.MODIFIED;
            }
            return IChangeDescription.ContentChange.NONE;
        }

        public IChangeDescription.PropertyChange getPropertyChange() {
            return IChangeDescription.PropertyChange.NONE;
        }

        public IChangeDescription.StructuralChange getStructuralChange() {
            if (this.change.isChangeType(1)) {
                return IChangeDescription.StructuralChange.ADD;
            }
            if (this.change.isChangeType(2)) {
                return IChangeDescription.StructuralChange.DELETE;
            }
            if (this.change.isChangeType(8)) {
                if (this.isRename) {
                    return IChangeDescription.StructuralChange.RENAME;
                }
                return IChangeDescription.StructuralChange.MOVE;
            }
            return IChangeDescription.StructuralChange.NONE;
        }

        public String computeDescription() {
            if (this.change instanceof ILogicalChange) {
                ILogicalChange logical = (ILogicalChange)this.change;
                StringBuffer buf = new StringBuffer();
                buf.append(ChangeDisplayer.getConflictInformation(logical, true, false));
                buf.append(" <-> ");
                buf.append(ChangeDisplayer.getConflictInformation(logical, false, false));
                return buf.toString();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeDescriptionComparator
    implements Comparator<IChangeDescription> {
        public static final ChangeDescriptionComparator instance = new ChangeDescriptionComparator();

        @Override
        public int compare(IChangeDescription o1, IChangeDescription o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getCurrentPath(), o2.getCurrentPath());
        }
    }

    public static class LocalChangeDescription
    implements IChangeDescription {
        final ILocalChange change;

        public LocalChangeDescription(ILocalChange change) {
            this.change = change;
        }

        public String getChangeLetters() {
            StringBuffer buf = new StringBuffer(2);
            if ((this.change.getType() & 2) != 0) {
                buf.append('a');
            } else if ((this.change.getType() & 4) != 0) {
                buf.append('d');
            } else {
                buf.append('-');
            }
            if ((this.change.getType() & 1) != 0) {
                buf.append('m');
            } else {
                buf.append('-');
            }
            if (this.change.isType(32)) {
                buf.append('p');
            } else {
                buf.append('-');
            }
            return buf.toString();
        }

        public String getCurrentPath() {
            return this.change.getPath().toString();
        }

        public IChangeDescription.ConflictType getConflictType() {
            return IChangeDescription.ConflictType.NONE;
        }

        public IChangeDescription.ContentChange getContentChange() {
            if ((this.change.getType() & 1) != 0) {
                return IChangeDescription.ContentChange.MODIFIED;
            }
            return IChangeDescription.ContentChange.NONE;
        }

        public IChangeDescription.PropertyChange getPropertyChange() {
            if (this.change.isType(32)) {
                return IChangeDescription.PropertyChange.MODIFIED;
            }
            return IChangeDescription.PropertyChange.NONE;
        }

        public IChangeDescription.StructuralChange getStructuralChange() {
            if ((this.change.getType() & 2) != 0) {
                return IChangeDescription.StructuralChange.ADD;
            }
            if ((this.change.getType() & 4) != 0) {
                return IChangeDescription.StructuralChange.DELETE;
            }
            if ((this.change.getType() & 0x18) != 0) {
                IPath original = this.change.getOriginalPath();
                IPath result = this.change.getResultingPath();
                assert (original != null);
                assert (result != null);
                if ((original = original.removeLastSegments(1)).equals((Object)(result = result.removeLastSegments(1)))) {
                    return IChangeDescription.StructuralChange.RENAME;
                }
                return IChangeDescription.StructuralChange.MOVE;
            }
            return IChangeDescription.StructuralChange.NONE;
        }

        public String computeDescription() {
            return null;
        }
    }
}

