/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands;

import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlowGroup {
    protected List<IChangeSetHandle> changesToFlow;
    protected final IWorkspaceConnection subject;
    protected final List<IComponentHandle> includedComponents;
    protected final IWorkspaceConnection collab;
    protected IChangeHistorySyncReport syncReport;

    protected AbstractFlowGroup(IWorkspaceConnection sub, List<IComponentHandle> included, IWorkspaceConnection clb) {
        this.subject = sub;
        this.includedComponents = included;
        this.collab = clb;
    }

    public boolean sameSubjectAndCollab(UUID subUUID, UUID clbUUID) {
        return this.getSubject().getContextHandle().getItemId().equals((Object)subUUID) && this.getCollab().getContextHandle().getItemId().equals((Object)clbUUID);
    }

    public abstract IWorkspaceConnection getSource();

    public abstract IWorkspaceConnection getTarget();

    public final IWorkspaceConnection getSubject() {
        return this.subject;
    }

    public final IWorkspaceConnection getCollab() {
        return this.collab;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[FlowGroup: " + this.getSource().getName() + " -> " + this.getTarget().getName() + ", components: ");
        boolean first = true;
        for (IComponentHandle comp : this.includedComponents) {
            if (!first) {
                buf.append(", ");
            }
            buf.append(comp.getItemId().getUuidValue());
            first = false;
        }
        buf.append(", changes: ");
        if (this.changesToFlow == null) {
            buf.append("<not-set>/");
            if (this.syncReport == null) {
                buf.append("<not-set>");
            } else {
                buf.append(this.syncReport.outgoingChangeSets().size());
            }
        } else {
            buf.append(this.changesToFlow.size());
            buf.append("/");
            buf.append(this.syncReport.outgoingChangeSets().size());
        }
        return buf.append("]").toString();
    }

    public List<IComponentHandle> getExcludedComponents(IClientConfiguration config) throws FileSystemClientException {
        return RepoUtil.componentComplement((IFlowNodeConnection)this.subject, this.includedComponents, (IClientConfiguration)config);
    }

    public List<IComponentHandle> getIncludedComponents() {
        return this.includedComponents;
    }

    protected final void setChangesToFlow(List<IChangeSetHandle> changes) {
        this.changesToFlow = changes;
    }

    protected abstract List<IChangeSetHandle> getChangesToFlow();

    protected abstract List<IChangeSetHandle> getAllChangesToFlow();

    public abstract List<IBaselineHandle> getBaselinesToFlow();

    public abstract List<IBaselineHandle> getNewBasis();
}

