/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.minimal.protocol.Message;
import com.ibm.team.filesystem.cli.minimal.protocol.MessageType;
import com.ibm.team.filesystem.cli.minimal.protocol.ProtocolUtil;
import com.ibm.team.filesystem.cli.minimal.protocol.Reader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RemoteInputStream
extends InputStream {
    private final InputStream in;
    private final OutputStream out;
    private final Object lock;

    public RemoteInputStream(Object lock, OutputStream out, InputStream in) {
        this.lock = lock;
        this.out = out;
        this.in = in;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Message msg;
            block7: {
                ProtocolUtil.writeMessage((OutputStream)this.out, (MessageType)MessageType.STDIN_READ, (byte[][])new byte[][]{"1".getBytes("UTF-8")});
                this.out.flush();
                msg = Reader.readMessage((InputStream)this.in);
                if (msg == null) {
                    throw new IOException("Unexpected front end termination");
                }
                if (msg.getMessageType() != MessageType.STDIN_CLOSED) break block7;
                return -1;
            }
            if (msg.getMessageType() == MessageType.STDIN_RESPONSE) {
                if (msg.getFields()[0].length != 1) {
                    throw new IOException("Expected exactly one byte in response. Got \"" + new String(msg.getFields()[0]) + "\" [" + msg.getFields()[0].length + "]");
                }
                return msg.getFields()[0][0];
            }
            throw new IOException("Unexpected message " + msg);
        }
    }
}

