/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.internal.daemon.RemoteInputStream;
import com.ibm.team.filesystem.cli.client.internal.daemon.RemoteOutputStream;
import com.ibm.team.filesystem.cli.core.IExecutionContext;
import com.ibm.team.filesystem.cli.minimal.protocol.Message;
import com.ibm.team.filesystem.cli.minimal.protocol.MessageType;
import com.ibm.team.filesystem.cli.minimal.protocol.ProtocolUtil;
import com.ibm.team.filesystem.cli.minimal.protocol.Reader;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteContext
implements IExecutionContext {
    final String appName;
    final FSDaemon daemon;
    final String[] arguments;
    final Map<String, String> env;
    final String cwd;
    private String[] terminatingError = null;
    private final InputStream in;
    private final OutputStream out;
    private final PrintStream stderr;
    private final PrintStream stdout;
    private InputStream stdin;

    public RemoteContext(String appName, FSDaemon daemon, InputStream in, OutputStream responseStream, LinkedList<String> args, Map<String, String> env, String cwd) {
        this.appName = appName;
        this.daemon = daemon;
        this.arguments = args.toArray(new String[args.size()]);
        this.env = env;
        this.in = in;
        this.out = responseStream;
        this.cwd = cwd;
        this.stdout = new PrintStream(new RemoteOutputStream(this, responseStream, MessageType.STDOUT));
        this.stderr = new PrintStream(new RemoteOutputStream(this, responseStream, MessageType.STDERR));
    }

    public String getAppName() {
        return this.appName;
    }

    public String[] arguments() {
        return this.arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassword(String prompt, boolean mask) throws IOException {
        RemoteContext remoteContext = this;
        synchronized (remoteContext) {
            ProtocolUtil.writeMessage((OutputStream)this.out, (MessageType)MessageType.PASSWORD_READ, (byte[][])new byte[][]{prompt.getBytes(), Boolean.toString(mask).getBytes("UTF-8")});
            this.out.flush();
            Message msg = Reader.readMessage((InputStream)this.in);
            if (msg.getMessageType() != MessageType.PASSWORD_RESPONSE) {
                throw new IOException("Unexpected message: " + msg.getMessageType());
            }
            return new String(msg.getFields()[0]);
        }
    }

    public void setTerminatingError(String title, String message) {
        this.terminatingError = new String[]{title, message};
    }

    public PrintStream stderr() {
        return this.stderr;
    }

    public PrintStream stdout() {
        return this.stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream stdin() {
        RemoteContext remoteContext = this;
        synchronized (remoteContext) {
            if (this.stdin == null) {
                this.stdin = new RemoteInputStream(this, this.out, this.in);
            }
            return this.stdin;
        }
    }

    public String[] getTerminatingError() {
        return this.terminatingError;
    }

    public Map<String, String> environment() {
        return this.env;
    }

    public String getCurrentWorkingDirectory() {
        return this.cwd;
    }

    public FSDaemon getDaemon() {
        return this.daemon;
    }
}

