/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.utils.IDaemonRegistry;
import com.ibm.team.filesystem.client.restproxy.DaemonRegistry;
import java.io.OutputStream;
import java.util.Collection;

public class ListDaemonCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final int COLWIDTH_PORT = 6;
    private static final int COLWIDTH_KEY = 34;

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false);
        opts.addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, Messages.ListDaemonCmd_VERBOSE_OPTION_HELP);
        return opts;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        DaemonRegistry reg = new DaemonRegistry(config.getConfigDirectory());
        boolean verbose = config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        Collection entries = reg.listDaemons(null);
        IndentingPrintStream root = new IndentingPrintStream((OutputStream)config.getContext().stdout());
        root.print(StringUtil.pad((CharSequence)Messages.ListDaemonCmd_COLUMN_LOCAL_PORT_NUMBER, (int)6));
        if (verbose) {
            root.print(StringUtil.pad((CharSequence)Messages.ListDaemonCmd_COLUMN_LOCAL_PASSWORD, (int)34));
        }
        root.print((CharSequence)Messages.ListDaemonCmd_COLUMN_DESCRIPTION_OF_DAEMON);
        root.println();
        for (IDaemonRegistry.IRegistryEntry entry : entries) {
            String desc;
            root.print(StringUtil.pad((CharSequence)Integer.toString(entry.getPort()), (int)6));
            if (verbose) {
                root.print(StringUtil.pad((CharSequence)entry.getKey(), (int)34));
            }
            root.print((CharSequence)((desc = entry.getDescription()) == null ? "" : desc));
            root.println();
            IDaemonRegistry.IDaemonSandbox[] sandboxes = entry.getRegisteredSandboxes();
            if (sandboxes.length == 0) continue;
            IndentingPrintStream sbPrinter = root.indent();
            IDaemonRegistry.IDaemonSandbox[] iDaemonSandboxArray = sandboxes;
            int n = sandboxes.length;
            int n2 = 0;
            while (n2 < n) {
                IDaemonRegistry.IDaemonSandbox sb = iDaemonSandboxArray[n2];
                sbPrinter.println((CharSequence)sb.getSandboxRoot().getAbsolutePath());
                ++n2;
            }
        }
    }
}

