/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.rest.ILifecycleRestClient;
import com.ibm.team.filesystem.client.restproxy.DaemonRegistry;
import com.ibm.team.filesystem.client.restproxy.Discovery2;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestHttpException;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestTransportException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.OutputStream;
import org.eclipse.osgi.util.NLS;

public class DaemonStopCmd
extends AbstractSubcommand
implements IOptionSource {
    static PositionalOptionDefinition OPT_CFAROOT = new PositionalOptionDefinition("share-root", 0, 1);
    static NamedOptionDefinition OPT_PORT = new NamedOptionDefinition("p", "port", 1);

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false);
        opts.addOption((IPositionalOptionDefinition)OPT_CFAROOT, Messages.DaemonStartCmd_0);
        opts.addOption((INamedOptionDefinition)OPT_PORT, Messages.DaemonStartCmd_PORT_TO_STOP);
        return opts;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ILifecycleRestClient client;
        ICommandLine args = config.getSubcommandCommandLine();
        String cfaRootString = args.getOption((IOptionKey)OPT_CFAROOT, null);
        String portString = args.getOption((IOptionKey)OPT_PORT, null);
        if (cfaRootString != null && portString != null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DaemonStopCmd_SPECIFY_ONLY_ONE_OF, (Object)OPT_CFAROOT.getName(), (Object)OPT_PORT.getName()));
        }
        if (cfaRootString == null && portString == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DaemonStopCmd_SPECIFY_ONE_OF, (Object)OPT_CFAROOT.getName(), (Object)OPT_PORT.getName()));
        }
        Discovery2.DiscoveryParams params = new Discovery2.DiscoveryParams().setAllowStart(false).setInterface(ILifecycleRestClient.class).setDaemonRegistry(new DaemonRegistry(config.getConfigDirectory()));
        if (cfaRootString != null) {
            File cfaRoot = SubcommandUtil.canonicalize((File)new File(cfaRootString));
            params.setPathToRoot(cfaRoot);
            cfaRootString = cfaRoot.getAbsolutePath();
        }
        int port = 0;
        if (portString != null) {
            boolean successfullyParsed = false;
            try {
                port = Integer.parseInt(portString);
                successfullyParsed = true;
            }
            catch (NumberFormatException numberFormatException) {}
            if (!successfullyParsed || port < 1) {
                throw StatusHelper.argSyntax((String)Messages.DaemonStopCmd_PORT_MUST_BE_POSITIVE);
            }
            params.setPort(port);
        }
        if ((client = (ILifecycleRestClient)Discovery2.RESOLVER.resolve(params, null)) == null) {
            if (cfaRootString != null) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DaemonStopCmd_0, (Object)cfaRootString));
            }
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DaemonStopCmd_COULD_NOT_FIND_DAEMON_ON_PORT, (Object)port));
        }
        if (config.isDryRun()) {
            return;
        }
        try {
            client.postShutdown();
        }
        catch (RestTransportException e) {
            if (e instanceof RestHttpException && ((RestHttpException)e).getHttpCode() == 404) {
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.DaemonStopCmd_SHUTDOWN_DISALLOWED, (Object)port));
            }
            throw StatusHelper.failure((String)NLS.bind((String)Messages.DaemonStopCmd_DAEMON_CONNECT_ERROR, (Object)port), (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            if (cfaRootString != null) {
                throw StatusHelper.wrap((String)NLS.bind((String)Messages.DaemonStopCmd_1, (Object)cfaRootString), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.DaemonStopCmd_COULD_NOT_SHUTDOWN_DAEMON_ON_PORT, (Object)port), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        config.getContext().stdout().println(Messages.DaemonStopCmd_2);
    }
}

