/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.daemon.DaemonStartCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.daemon.JSONHandler;
import com.ibm.team.filesystem.client.daemon.JSONMethod;
import com.ibm.team.filesystem.client.daemon.events.ConnectionEvent;
import com.ibm.team.filesystem.client.daemon.events.IHttpServerEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.daemon.events.ShutdownStartedEvent;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.http.HttpContext;
import com.ibm.team.filesystem.client.internal.http.HttpHandler;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import com.ibm.team.filesystem.client.internal.utils.IDaemonRegistry;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.ILifecycleRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxes;
import com.ibm.team.filesystem.client.restproxy.DaemonRegistry;
import com.ibm.team.filesystem.client.restproxy.Discovery2;
import com.ibm.team.filesystem.client.restproxy.IDaemonHandle;
import com.ibm.team.filesystem.rcp.core.internal.rest.DebugRestClient;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonStartCmd
extends AbstractSubcommand {
    private static String PROP_DAEMON_LOG = "daemon.log.file";
    private static final Log log = LogFactory.getLog((String)DaemonStartCmd.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine args = config.getSubcommandCommandLine();
        List<String> sandboxes = null;
        if (args.hasOption((IOptionKey)DaemonStartCmdOpts.OPT_CFAROOT)) {
            sandboxes = args.getOptions((IOptionKey)DaemonStartCmdOpts.OPT_CFAROOT);
            sandboxes = this.canonicalize(config, sandboxes);
        }
        long maxConnectionWait = 0L;
        try {
            maxConnectionWait = new Long(args.getOption((IOptionKey)DaemonStartCmdOpts.OPT_CONNECTION_TIMEOUT, "0"));
        }
        catch (NumberFormatException numberFormatException) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DaemonStartCmd_INVALID_INITIAL_TIMEOUT, (Object)DaemonStartCmdOpts.OPT_CONNECTION_TIMEOUT.getName(), (Object)args.getOption((IOptionKey)DaemonStartCmdOpts.OPT_CONNECTION_TIMEOUT)));
        }
        long idleTimeout = -1L;
        try {
            idleTimeout = new Long(args.getOption((IOptionKey)DaemonStartCmdOpts.OPT_IDLE_TIMEOUT, "-1"));
        }
        catch (NumberFormatException numberFormatException) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DaemonStartCmd_INVALID_IDLE_TIMEOUT, (Object)DaemonStartCmdOpts.OPT_IDLE_TIMEOUT.getName(), (Object)args.getOption((IOptionKey)DaemonStartCmdOpts.OPT_IDLE_TIMEOUT)));
        }
        this.initializeDebugInterface(config);
        DaemonRegistry reg = new DaemonRegistry(config.getConfigDirectory());
        Discovery2.DiscoveryParams params = new Discovery2.DiscoveryParams().setAcceptAny(false).setRunInProcess(true).setInterface(ILifecycleRestClient.class).setAllowStart(true).setDaemonRegistry(reg);
        if (System.getProperty(PROP_DAEMON_LOG) != null) {
            params.setLogFile(new File(System.getProperty(PROP_DAEMON_LOG)));
        }
        Object o = Discovery2.RESOLVER.resolve(params, null);
        IDaemonHandle loc = Discovery2.RESOLVER.find(o);
        final InitialWaitEscapeReason[] gottenConnection = new InitialWaitEscapeReason[]{InitialWaitEscapeReason.TIMEOUT};
        FSDaemon fsd = loc.getInProcessServer();
        fsd.setDescription(this.createDescription(args.getOption((IOptionKey)DaemonStartCmdOpts.OPT_DAEMON_DESCRIPTION, null)), null);
        if (sandboxes != null && sandboxes.size() > 0) {
            try {
                this.registerSandboxes(sandboxes, loc);
            }
            catch (FileSystemClientException e) {
                if (27 == e.getStatus().getCode()) {
                    this.showSandboxOwners(reg, sandboxes, config);
                }
                throw e;
            }
        }
        this.displayConnectInfo(loc.getPort(), loc.getKey(), config);
        System.out.close();
        System.err.close();
        ILightweightEventListener<IHttpServerEvent> l = new ILightweightEventListener<IHttpServerEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleEvent(IHttpServerEvent event) {
                if (event instanceof ConnectionEvent && ((ConnectionEvent)event).getType() == ConnectionEvent.Type.OPENED) {
                    InitialWaitEscapeReason[] initialWaitEscapeReasonArray = gottenConnection;
                    synchronized (gottenConnection) {
                        gottenConnection[0] = InitialWaitEscapeReason.CONNECTION;
                        gottenConnection.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
                if (!(event instanceof ShutdownStartedEvent)) return;
                InitialWaitEscapeReason[] initialWaitEscapeReasonArray = gottenConnection;
                synchronized (gottenConnection) {
                    gottenConnection[0] = InitialWaitEscapeReason.SHUTDOWN;
                    gottenConnection.notifyAll();
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return;
                }
            }
        };
        InitialWaitEscapeReason[] initialWaitEscapeReasonArray = gottenConnection;
        synchronized (gottenConnection) {
            fsd.getHttpServer().addListener((ILightweightEventListener)l);
            if (maxConnectionWait > 0L) {
                try {
                    gottenConnection.wait(maxConnectionWait);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Unexpected interruption while waiting for initial connection", (Throwable)e);
                }
            } else {
                gottenConnection[0] = InitialWaitEscapeReason.CONNECTION;
            }
            switch (gottenConnection[0]) {
                case CONNECTION: {
                    this.installShutdownTimer(fsd, idleTimeout);
                    break;
                }
                case SHUTDOWN: {
                    // ** MonitorExit[var15_14] (shouldn't be in output)
                    return;
                }
                case TIMEOUT: {
                    try {
                        fsd.getHttpServer().shutdown();
                    }
                    catch (IOException e) {
                        log.error((Object)("Exception while shutting down server: " + e.getMessage()), (Throwable)e);
                    }
                    throw StatusHelper.initialConnectionTimeout((long)maxConnectionWait);
                }
            }
            // ** MonitorExit[var15_14] (shouldn't be in output)
            try {
                Discovery2.RESOLVER.joinInProcess(o);
            }
            catch (InterruptedException interruptedException) {
                config.getContext().stderr().println("Unexpected interrupt while waiting for daemon to shutdown.");
            }
            return;
        }
    }

    private List<String> canonicalize(IClientConfiguration config, List<String> sandboxes) throws FileSystemClientException {
        List paths = SubcommandUtil.makeAbsolutePaths((IClientConfiguration)config, sandboxes);
        ArrayList<String> toReturn = new ArrayList<String>(paths.size());
        for (IPath path : paths) {
            toReturn.add(path.toOSString());
        }
        return toReturn;
    }

    private void initializeDebugInterface(final IClientConfiguration config) {
        DebugRestClient.setPlatformInformationSource((DebugRestClient.IPlatformInformationSource)new DebugRestClient.IPlatformInformationSource(){

            public String getEclipseWorkspacePath() {
                return config.getEclipseWorkspaceRoot().getAbsolutePath();
            }

            public String getUserConfigurationPath() {
                try {
                    return config.getConfigDirectory().getAbsolutePath();
                }
                catch (FileSystemClientException e) {
                    LoggingHelper.log((CoreException)((Object)e));
                    return null;
                }
            }
        });
    }

    private String createDescription(String option) {
        if (option == null) {
            Bundle bundle = Platform.getBundle((String)"com.ibm.team.filesystem.cli.client");
            Dictionary headers = bundle.getHeaders();
            String version = Messages.DaemonStartCmd_UNKNOWN_APPLICATION_VERSION;
            Enumeration i = headers.keys();
            while (i.hasMoreElements()) {
                String candidate = (String)i.nextElement();
                if (!"bundle-version".equals(candidate.toLowerCase())) continue;
                version = (String)headers.get(candidate);
                break;
            }
            option = NLS.bind((String)Messages.DaemonStartCmd_APP_DESCRIPTION, (Object)version);
        }
        return option;
    }

    private void registerSandboxes(List<String> sandboxes, IDaemonHandle loc) throws FileSystemClientException {
        FSDaemon daemon = loc.getInProcessServer();
        HttpContext ctx = daemon.getHttpServer().getContextFor(HttpMethod.POST, new String[]{"service"});
        JSONHandler jsonHandler = (JSONHandler)ctx.getHandler();
        JSONMethod method = jsonHandler.getMethod(HttpMethod.POST, new String[]{"service", IFilesystemRestClient.class.getName(), "RegisterSandboxes"});
        IFilesystemRestClient frc = (IFilesystemRestClient)method.getReceiver();
        ParmsSandboxes parms = new ParmsSandboxes(sandboxes.toArray(new String[sandboxes.size()]));
        try {
            frc.postRegisterSandboxes(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.cfaInUse((String)NLS.bind((String)Messages.DaemonStartCmd_COULD_NOT_LOCK_FOLDER, (Object)e.getData()));
        }
    }

    private void showSandboxOwners(DaemonRegistry reg, List<String> sandboxes, IClientConfiguration config) {
        Collection entries = reg.listDaemons(null);
        HashSet<File> files = new HashSet<File>(sandboxes.size());
        for (String sb : sandboxes) {
            try {
                files.add(SubcommandUtil.canonicalize((File)new File(sb)));
            }
            catch (FileSystemClientException fileSystemClientException) {
                config.getContext().stderr().println(NLS.bind((String)Messages.DaemonStartCmd_CANONICAL_PATH_FAILURE, (Object)sb));
            }
        }
        IndentingPrintStream err = new IndentingPrintStream((OutputStream)System.err);
        boolean showMessage = true;
        for (IDaemonRegistry.IRegistryEntry entry : entries) {
            IDaemonRegistry.IDaemonSandbox[] iDaemonSandboxArray = entry.getRegisteredSandboxes();
            int n = iDaemonSandboxArray.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    File root;
                    IDaemonRegistry.IDaemonSandbox sbEntry = iDaemonSandboxArray[n2];
                    try {
                        root = SubcommandUtil.canonicalize((File)new File(sbEntry.getSandboxRoot().getPath()));
                    }
                    catch (FileSystemClientException fileSystemClientException) {
                        config.getContext().stderr().println(NLS.bind((String)Messages.DaemonStartCmd_NO_PATH_TO_FOLDER, (Object)sbEntry.getSandboxRoot()));
                        break block10;
                    }
                    if (files.contains(root)) {
                        if (showMessage) {
                            err.println((CharSequence)Messages.DaemonStartCmd_DIRECTORY_LOCKED_BY_OTHER_DAEMON);
                            err = err.indent();
                            showMessage = false;
                        }
                        err.println((CharSequence)NLS.bind((String)"{0} {1} : {2}", (Object[])new String[]{Integer.toString(entry.getPort()), entry.getKey(), root.getAbsolutePath()}));
                    }
                }
                ++n2;
            }
        }
        if (showMessage) {
            config.getContext().stderr().println(Messages.DaemonStartCmd_DIRECTORY_LOCKED_BY_OTHER_PROGRAM);
        }
    }

    private void installShutdownTimer(FSDaemon fsd, long idleTimeout) throws FileSystemClientException {
        if (idleTimeout < 0L) {
            return;
        }
        HttpContext ctx = fsd.getHttpServer().getContextFor(HttpMethod.POST, new String[]{"service"});
        HttpHandler handler = ctx.getHandler();
        JSONMethod method = ((JSONHandler)handler).getMethod(HttpMethod.POST, new String[]{"service", ILifecycleRestClient.class.getName(), "Timeout"});
        try {
            method.getMethod().invoke(method.getReceiver(), new ILifecycleRestClient.TimeoutParam(idleTimeout));
        }
        catch (IllegalArgumentException e) {
            throw StatusHelper.failure((String)"Unable to set timeout", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw StatusHelper.failure((String)"Unable to set timeout", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw StatusHelper.failure((String)"Unable to set timeout", (Throwable)e);
        }
    }

    private void displayConnectInfo(int port, String key, IClientConfiguration config) {
        config.getContext().stdout().println("Port: " + port);
        config.getContext().stdout().println("Key: " + key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InitialWaitEscapeReason {
        CONNECTION,
        SHUTDOWN,
        TIMEOUT;

    }
}

