/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxes;
import com.ibm.team.filesystem.client.restproxy.DaemonRegistry;
import com.ibm.team.filesystem.client.restproxy.Discovery2;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.osgi.util.NLS;

public class DaemonRegisterCmd
extends AbstractSubcommand
implements IOptionSource {
    static PositionalOptionDefinition OPT_PORT = new PositionalOptionDefinition("port", 1, 1);
    static PositionalOptionDefinition OPT_CFAROOT = new PositionalOptionDefinition("share-root", 1, 1);

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false);
        opts.addOption((IPositionalOptionDefinition)OPT_PORT, Messages.DaemonRegisterCmd_DAEMON_PORT);
        opts.addOption((IPositionalOptionDefinition)OPT_CFAROOT, Messages.DaemonRegisterCmd_SANDBOX_PATH);
        return opts;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine args = config.getSubcommandCommandLine();
        String cfaRootString = SubcommandUtil.canonicalize((String)args.getOption((IOptionKey)OPT_CFAROOT, null));
        int port = 0;
        boolean successfullyParsed = false;
        try {
            port = Integer.parseInt(args.getOption((IOptionKey)OPT_PORT, null));
            successfullyParsed = true;
        }
        catch (NumberFormatException numberFormatException) {}
        if (!successfullyParsed || port < 1) {
            throw StatusHelper.argSyntax((String)Messages.DaemonStopCmd_PORT_MUST_BE_POSITIVE);
        }
        Discovery2.DiscoveryParams params = new Discovery2.DiscoveryParams().setAllowStart(false).setPort(port).setInterface(IFilesystemRestClient.class).setDaemonRegistry(new DaemonRegistry(config.getConfigDirectory()));
        IFilesystemRestClient client = (IFilesystemRestClient)Discovery2.RESOLVER.resolve(params, null);
        if (client == null) {
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DaemonStopCmd_COULD_NOT_FIND_DAEMON_ON_PORT, (Object)port));
        }
        ParmsSandboxes parms = new ParmsSandboxes(new String[]{cfaRootString});
        try {
            client.postRegisterSandboxes(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.failure((String)Messages.DaemonRegisterCmd_REGISTRATION_FAILED, (Throwable)e);
        }
        config.getContext().stdout().println(Messages.DaemonRegisterCmd_SUCCESS_MESSAGE);
    }
}

