/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxes;
import com.ibm.team.filesystem.client.restproxy.DaemonRegistry;
import com.ibm.team.filesystem.client.restproxy.Discovery2;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import org.eclipse.osgi.util.NLS;

public class DaemonDeregisterCmd
extends AbstractSubcommand
implements IOptionSource {
    static PositionalOptionDefinition OPT_CFAROOT = new PositionalOptionDefinition("share-root", 1, 1);

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false);
        opts.addOption((IPositionalOptionDefinition)OPT_CFAROOT, Messages.DaemonStartCmd_0);
        return opts;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine args = config.getSubcommandCommandLine();
        String cfaRootString = args.getOption((IOptionKey)OPT_CFAROOT, null);
        File cfaRoot = SubcommandUtil.canonicalize((File)new File(cfaRootString));
        cfaRootString = cfaRoot.getAbsolutePath();
        Discovery2.DiscoveryParams params = new Discovery2.DiscoveryParams().setAllowStart(false).setPathToRoot(cfaRoot).setInterface(IFilesystemRestClient.class).setDaemonRegistry(new DaemonRegistry(config.getConfigDirectory()));
        IFilesystemRestClient client = (IFilesystemRestClient)Discovery2.RESOLVER.resolve(params, null);
        if (client == null) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DaemonDeregisterCmd_CANNOT_FIND_SANDBOX_OWNER, (Object)cfaRootString));
        }
        if (!config.isDryRun()) {
            ParmsSandboxes parms = new ParmsSandboxes(new String[]{cfaRootString});
            try {
                client.postDeregisterSandbox(parms, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.DaemonDeregisterCmd_LOG_MESSAGE, (Object)cfaRootString), (Throwable)e);
            }
        }
        config.getContext().stdout().println(Messages.DaemonDeregisterCmd_SANDBOX_SUCCESSFULLY_DEREGISTERED);
    }
}

