/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.internal.daemon.MultiplexingInputStream;
import com.ibm.team.filesystem.cli.client.internal.daemon.MultiplexingOutputStream;
import com.ibm.team.filesystem.cli.client.internal.daemon.RemoteContext;
import com.ibm.team.filesystem.cli.core.IExecutionContext;
import com.ibm.team.filesystem.cli.core.internal.SubcommandLauncher;
import com.ibm.team.filesystem.cli.minimal.protocol.Message;
import com.ibm.team.filesystem.cli.minimal.protocol.MessageType;
import com.ibm.team.filesystem.cli.minimal.protocol.ProtocolUtil;
import com.ibm.team.filesystem.cli.minimal.protocol.Reader;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.http.HttpContext;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.http.HttpServer;
import com.ibm.team.filesystem.client.internal.http.IExternalManager;
import com.ibm.team.filesystem.client.internal.http.ProtocolSwitchingHttpHandler;
import com.ibm.team.repository.common.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineClient
extends ProtocolSwitchingHttpHandler
implements IExternalManager {
    private static final Log log = LogFactory.getLog((String)CommandLineClient.class.getName());
    private static final String GROUP_FEC = "FrontEndClient";
    private FSDaemon daemon;
    private static final Object STREAM_LOCK = new Object();
    private static boolean streamsInstalled = false;
    private static final MultiplexingOutputStream stdoutStream = new MultiplexingOutputStream(System.out);
    private static final MultiplexingOutputStream stderrStream = new MultiplexingOutputStream(System.err);
    private static final MultiplexingInputStream stdinStream = new MultiplexingInputStream(System.in);

    public boolean willManage(HttpRequest request, HttpResponse response) {
        return true;
    }

    protected String getProtocol() {
        return "vnd.ibm.jazz.cli.minimal-1.0";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleRequest(HttpRequest request, HttpResponse response) throws IOException {
        int result;
        RemoteContext ctx;
        block21: {
            InputStream in = response.getInputStream();
            LinkedList<String> args = new LinkedList<String>();
            HashMap<String, String> env = new HashMap<String, String>();
            String cwd = null;
            block14: while (true) {
                Message msg = Reader.readMessage((InputStream)in);
                switch (msg.getMessageType()) {
                    case ARGUMENT: {
                        args.add(new String(msg.getFields()[0]));
                        continue block14;
                    }
                    case ENVIRONMENT: {
                        env.put(new String(msg.getFields()[0]), new String(msg.getFields()[1]));
                        continue block14;
                    }
                    case CWD: {
                        cwd = new String(msg.getFields()[0], "UTF-8");
                        continue block14;
                    }
                    case PREAMBLE_DONE: {
                        break block14;
                    }
                    default: {
                        throw new IOException("Unexpected message: " + msg.getMessageType());
                    }
                }
                break;
            }
            ctx = this.createInteractionContext(in, response.getResponseStream(), args, env, cwd);
            SubcommandLauncher runner = new SubcommandLauncher(GROUP_FEC, ctx.stderr());
            result = -1;
            try {
                block19: {
                    if (cwd != null) break block19;
                    ctx.stderr().print(new RuntimeException("CWD not defined"));
                    if (ctx.getTerminatingError() != null) {
                        ctx.stderr().println(String.valueOf(ctx.getTerminatingError()[0]) + ":");
                        ctx.stderr().println(ctx.getTerminatingError()[1]);
                    }
                    ctx.stdout().flush();
                    ctx.stderr().flush();
                    ProtocolUtil.writeMessage((OutputStream)response.getResponseStream(), (MessageType)MessageType.EXIT_CODE, (byte[][])new byte[][]{{(byte)result}});
                    response.getResponseStream().flush();
                    System.gc();
                    return;
                }
                try {
                    try {
                        result = runner.run((IExecutionContext)ctx, null, null);
                    }
                    catch (Exception e) {
                        ctx.stderr().print(e.toString());
                        result = -13;
                        if (ctx.getTerminatingError() != null) {
                            ctx.stderr().println(String.valueOf(ctx.getTerminatingError()[0]) + ":");
                            ctx.stderr().println(ctx.getTerminatingError()[1]);
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (ctx.getTerminatingError() != null) {
                        ctx.stderr().println(String.valueOf(ctx.getTerminatingError()[0]) + ":");
                        ctx.stderr().println(ctx.getTerminatingError()[1]);
                    }
                    throw throwable;
                }
                if (ctx.getTerminatingError() != null) {
                    ctx.stderr().println(String.valueOf(ctx.getTerminatingError()[0]) + ":");
                    ctx.stderr().println(ctx.getTerminatingError()[1]);
                }
            }
            catch (Throwable throwable) {
                ctx.stdout().flush();
                ctx.stderr().flush();
                ProtocolUtil.writeMessage((OutputStream)response.getResponseStream(), (MessageType)MessageType.EXIT_CODE, (byte[][])new byte[][]{{(byte)result}});
                response.getResponseStream().flush();
                System.gc();
                throw throwable;
            }
        }
        ctx.stdout().flush();
        ctx.stderr().flush();
        ProtocolUtil.writeMessage((OutputStream)response.getResponseStream(), (MessageType)MessageType.EXIT_CODE, (byte[][])new byte[][]{{(byte)result}});
        response.getResponseStream().flush();
        System.gc();
    }

    private RemoteContext createInteractionContext(InputStream in, OutputStream responseStream, LinkedList<String> args, Map<String, String> env, String cwd) {
        return new RemoteContext("scm", this.daemon, in, responseStream, args, env, cwd);
    }

    public void registered(FSDaemon fsd, HttpServer httpServer, Collection<HttpContext> contexts) {
        this.daemon = fsd;
    }

    public void remoteClosed() {
    }

    public void shutdown() {
    }
}

