/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.OptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ConflictsProhibitOperationException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CreateSnapshotCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_DESC = new OptionKey("desc");
    public static final IOptionKey OPT_NAME = new OptionKey("name");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1), Messages.ListSnapshotsCmd_5).addOption(OPT_NAME, "n", "name", Messages.CreateSnapshotCmd_Name, 1).addOption(OPT_DESC, "d", "description", Messages.CreateSnapshotCmd_Description, 1);
        return options;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ConnectionInfo connectionInfo = config.getConnectionInfo();
        ICommandLine cli = config.getSubcommandCommandLine();
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connectionInfo);
        IWorkspaceConnection workspaceConnection = null;
        try {
            String wsSelector = cli.getOption(CommonOptions.OPT_WORKSPACE);
            workspaceConnection = RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)true, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_1, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_0, (Object)e.getSelector()));
        }
        String name = workspaceConnection.getResolvedWorkspace().getName();
        if (cli.hasOption(OPT_NAME)) {
            name = cli.getOption(OPT_NAME);
        }
        String description = "";
        if (cli.hasOption(OPT_DESC)) {
            description = cli.getOption(OPT_DESC);
        }
        try {
            IBaselineSetHandle snapshotHandle = workspaceConnection.createBaselineSet(null, name, description, true, null);
            IBaselineSet snapshot = (IBaselineSet)repo.itemManager().fetchCompleteItem((IItemHandle)snapshotHandle, 0, null);
            List baselineHandles = snapshot.getBaselines();
            List baselines = repo.itemManager().fetchCompleteItems(baselineHandles, 0, null);
            config.getContext().stdout().println(NLS.bind((String)Messages.CreateSnapshotCmd_SnapshotSuccessfullyCreated, (Object)AliasUtil.selector((String)snapshot.getName(), (UUID)snapshot.getItemId())));
            for (IBaseline baseline : baselines) {
                config.getContext().stdout().println(NLS.bind((String)Messages.CreateSnapshotCmd_BaselineSuccessfullyIncluded, (Object)AliasUtil.selector((int)baseline.getId(), (String)baseline.getName(), (UUID)baseline.getItemId())));
            }
        }
        catch (ConflictsProhibitOperationException conflictsProhibitOperationException) {
            throw StatusHelper.conflict((String)Messages.CreateSnapshotCmd_CouldNotCreateSnapshotConflict);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.CreateSnapshotCmd_CouldNotCreateSnapshotTRE, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
    }
}

