/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.OptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConfigurationChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.restproxy.Discovery2;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CreateComponentCommand
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_NAME = new OptionKey("name");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_NAME, "name", 1, 1), Messages.CreateComponentCommand_NameForTheComponent).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1), Messages.CreateComponentCommand_WorkspaceToAddComponent);
        return options;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ConnectionInfo connectionInfo = config.getConnectionInfo();
        ICommandLine cli = config.getSubcommandCommandLine();
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connectionInfo);
        IWorkspaceConnection workspaceConnection = null;
        try {
            String wsSelector = cli.getOption(CommonOptions.OPT_WORKSPACE);
            workspaceConnection = RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)true, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_1, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_0, (Object)e.getSelector()));
        }
        String name = cli.getOption(OPT_NAME);
        IFilesystemRestClient client = (IFilesystemRestClient)Discovery2.RESOLVER.resolve(new Discovery2.DiscoveryParams().setAcceptAny(false).setRunInProcess(true).setInterface(IFilesystemRestClient.class).setAllowStart(true), null);
        UUID componentItemId = null;
        try {
            ParmsPutWorkspace parms = new ParmsPutWorkspace();
            parms.workspace = new ParmsWorkspace();
            parms.workspace.repositoryUrl = repo.getRepositoryURI();
            parms.workspace.workspaceItemId = workspaceConnection.getResolvedWorkspace().getItemId().getUuidValue();
            parms.configurationChanges = new ParmsConfigurationChanges();
            parms.configurationChanges.components = new ParmsComponentChange[]{new ParmsComponentChange()};
            parms.configurationChanges.components[0].cmd = "addComponent";
            parms.configurationChanges.components[0].name = name;
            PutWorkspaceResultDTO result = client.postPutWorkspace(parms, null);
            if (!result.isSetComponentsAdded()) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.CreateComponentCommand_CouldNotCreateComponent, (Object)name), null);
            }
            List componentsAdded = result.getComponentsAdded();
            if (componentsAdded.size() != 1) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.CreateComponentCommand_CouldNotCreateComponent, (Object)name), null);
            }
            ConfigurationDescriptorDTO componentDTO = (ConfigurationDescriptorDTO)componentsAdded.get(0);
            componentItemId = UUID.valueOf((String)componentDTO.getComponentItemId());
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.CreateComponentCommand_CouldNotCreateComponent, (Object)name), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        config.getContext().stdout().println(NLS.bind((String)Messages.CreateComponentCommand_ComponentSuccessfullyCreated, (Object)AliasUtil.selector((String)name, (UUID)componentItemId)));
    }
}

