/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CreateChangeSetCmd
extends AbstractSubcommand
implements IOptionSource {
    static final NamedOptionDefinition OPT_COMPONENT_NAME = new NamedOptionDefinition(null, "component", 1);
    static final NamedOptionDefinition OPT_NO_CURRENT = new NamedOptionDefinition("n", "no-current", 0);
    static final PositionalOptionDefinition OPT_COMMENT = new PositionalOptionDefinition("comment", 0, 1);

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)opts);
        opts.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP).addOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME, Messages.CreateChangeSetCmd_0).addOption((INamedOptionDefinition)OPT_COMPONENT_NAME, Messages.CreateChangeSetCmd_1).addOption((IPositionalOptionDefinition)OPT_COMMENT, Messages.CreateChangeSetCmd_10).addOption((INamedOptionDefinition)OPT_NO_CURRENT, Messages.CreateChangeSetCmd_11);
        return opts;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        IChangeSetHandle csHandle;
        ICommandLine cli = config.getSubcommandCommandLine();
        String uri = cli.getOption((IOptionKey)CommonOptions.OPT_URI, null);
        String wsSelector = cli.getOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null);
        IWorkspaceConnection wsConn = RepoUtil.findWorkspaceConnection((IClientConfiguration)config, (String)uri, (String)wsSelector);
        IComponentHandle compHandle = this.findComponent(config, wsConn, cli.getOption((IOptionKey)OPT_COMPONENT_NAME, null));
        if (config.isDryRun()) {
            return;
        }
        try {
            csHandle = wsConn.createChangeSet(compHandle, cli.getOption((IOptionKey)OPT_COMMENT, ""), !cli.hasOption((IOptionKey)OPT_NO_CURRENT), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.CreateChangeSetCmd_8, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        config.getContext().stdout().println(NLS.bind((String)Messages.CreateChangeSetCmd_9, (Object)AliasUtil.alias((IItemHandle)csHandle)));
    }

    private IComponentHandle findComponent(IClientConfiguration config, IWorkspaceConnection wsConn, String compSelector) throws FileSystemClientException {
        List fullComps;
        List compHandles;
        if (compSelector == null) {
            List handles;
            try {
                handles = wsConn.getComponents();
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.CreateChangeSetCmd_2, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            if (handles.size() == 1) {
                return (IComponentHandle)handles.get(0);
            }
            ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
            Collection repoViews = cfaView.getLoadedWorkspaces();
            for (ICopyFileAreaView.IRepoView view : repoViews) {
                Collection comps;
                if (!view.getHandle().sameItemId((IItemHandle)wsConn.getContextHandle()) || (comps = cfaView.getLoadedComponents(view)).size() != 1) continue;
                return (IComponentHandle)((ItemId)comps.iterator().next()).toHandle((Object)wsConn.teamRepository());
            }
            throw StatusHelper.ambiguousSelector((String)Messages.CreateChangeSetCmd_3);
        }
        try {
            compHandles = wsConn.getComponents();
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.CreateChangeSetCmd_7, (Object)wsConn.getName()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        UUID uuidSelect = RepoUtil.lookupUuid((String)compSelector);
        if (uuidSelect != null) {
            for (IComponentHandle compHandle : compHandles) {
                if (!uuidSelect.equals((Object)compHandle.getItemId())) continue;
                return compHandle;
            }
        }
        try {
            fullComps = wsConn.teamRepository().itemManager().fetchCompleteItems(compHandles, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.CreateChangeSetCmd_5, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        LinkedList<IComponent> matches = new LinkedList<IComponent>();
        for (IComponent comp : fullComps) {
            if (!compSelector.equals(comp.getName())) continue;
            matches.add(comp);
        }
        if (matches.size() == 1) {
            return (IComponentHandle)matches.get(0);
        }
        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateChangeSetCmd_4, (Object)wsConn.getName(), (Object)compSelector));
    }
}

