/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ConflictsProhibitOperationException;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;

public class CreateBaselineCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_BASELINE_DESCRIPTION = new NamedOptionDefinition(null, "description", 1);
    public static final PositionalOptionDefinition OPT_WORKSPACE_NAME = new PositionalOptionDefinition("workspace-name", 1, 1);
    public static final PositionalOptionDefinition OPT_BASELINE_NAME = new PositionalOptionDefinition("baseline-name", 1, 1);

    public void run(IClientConfiguration config) throws FileSystemClientException {
        List componentHandles;
        IWorkspaceConnection workspaceConnection;
        ICommandLine subargs = config.getSubcommandCommandLine();
        String workspaceName = null;
        List componentNames = null;
        String baselineDescription = null;
        workspaceName = subargs.getOption((IOptionKey)OPT_WORKSPACE_NAME);
        boolean allComponents = subargs.hasOption((IOptionKey)CommonOptions.OPT_ALL);
        if (allComponents && subargs.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR)) {
            throw StatusHelper.argSyntax((String)Messages.CreateBaselineCmd_5);
        }
        if (!allComponents) {
            if (!subargs.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR)) {
                throw StatusHelper.argSyntax((String)Messages.CreateBaselineCmd_6);
            }
            componentNames = subargs.getOptions((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR);
        }
        String baselineName = subargs.getOption((IOptionKey)OPT_BASELINE_NAME);
        if (subargs.hasOption((IOptionKey)OPT_BASELINE_DESCRIPTION)) {
            baselineDescription = subargs.getOption((IOptionKey)OPT_BASELINE_DESCRIPTION);
        }
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
        try {
            workspaceConnection = RepoUtil.findNamedWorkspaceConnection((String)workspaceName, (boolean)true, (boolean)false, (ITeamRepository)repo, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_1, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_0, (Object)e.getSelector()));
        }
        if (allComponents) {
            try {
                componentHandles = workspaceConnection.getComponents();
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.CreateBaselineCmd_11, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
        }
        try {
            componentHandles = RepoUtil.findNamedComponents((List)componentNames, (boolean)false, (IWorkspaceConnection)workspaceConnection, (ITeamRepository)repo, (boolean)true, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)Messages.CreateBaselineCmd_12);
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)Messages.CreateBaselineCmd_13);
        }
        MyCreateBaselineDilemmaHandler handler = new MyCreateBaselineDilemmaHandler(subargs.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED));
        ICreateBaselineOperation op = OperationFactory.getInstance().getCreateBaselineOperation((CreateBaselineDilemmaHandler)handler);
        op.setRefreshBeforeRun(true);
        for (IComponentHandle comp : componentHandles) {
            op.createBaselineRequest(workspaceConnection, comp, baselineName, baselineDescription);
        }
        if (!config.isDryRun()) {
            try {
                op.run(null);
            }
            catch (OperationCanceledException e) {
                if (handler.encounteredDilemma) {
                    if (handler.isConflicted) {
                        throw StatusHelper.conflict((String)Messages.CreateBaselineCmd_ERROR_UNRESOLVED_REMOTE_CONFLICTS);
                    }
                    if (handler.hasUncheckedInChanges) {
                        throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.CreateBaselineCmd_ERROR_UNCOMMITTED_CHANGES_TO_LOCAL_FILESYSTEM, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
                    }
                    if (handler.isOutOfSync) {
                        throw StatusHelper.outOfSync((String)Messages.CreateBaselineCmd_ERROR_REMOTE_WORKSPACE_NOT_IN_SYNC_WITH_LOCAL_WORKSPACE);
                    }
                    throw StatusHelper.internalError((String)Messages.CreateBaselineCmd_ERROR_INTERNAL_ERROR);
                }
                throw StatusHelper.failure((String)Messages.CreateBaselineCmd_ERROR_UNEXPECTED_CANCELLATION, (Throwable)e);
            }
            catch (ConflictsProhibitOperationException conflictsProhibitOperationException) {
                throw StatusHelper.conflict((String)Messages.CreateBaselineCmd_20);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.CreateBaselineCmd_14, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
        }
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp(Messages.CreateBaselineCmd_15);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)OPT_BASELINE_DESCRIPTION, Messages.CreateBaselineCmd_16).addOption((INamedOptionDefinition)CommonOptions.OPT_ALL, CommonOptions.OPT_ALL_HELP).addOption((IPositionalOptionDefinition)OPT_WORKSPACE_NAME, Messages.CreateBaselineCmd_17).addOption((IPositionalOptionDefinition)OPT_BASELINE_NAME, Messages.CreateBaselineCmd_18).addOption((INamedOptionDefinition)CommonOptions.OPT_OVERWRITE_UNCOMMITTED, Messages.CreateBaselineCmd_HELP_IGNORE_UNCOMMITTED_LOCAL_CHANGES).addOption((IPositionalOptionDefinition)CommonOptions.OPT_COMPONENTS_SELECTOR, CommonOptions.OPT_COMPONENTS_SELECTOR_HELP);
        return options;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyCreateBaselineDilemmaHandler
    extends CreateBaselineDilemmaHandler {
        final boolean ignoreUncommittedChanges;
        boolean isConflicted = false;
        boolean hasUncheckedInChanges = false;
        boolean isOutOfSync = false;
        boolean encounteredDilemma = false;

        public MyCreateBaselineDilemmaHandler(boolean ignoreUncommittedChanges) {
            this.ignoreUncommittedChanges = ignoreUncommittedChanges;
        }

        public int conflictedConfigurations(List<ConfigurationDescriptor> conflictedConfigurations) {
            this.encounteredDilemma = true;
            this.isConflicted = true;
            throw new OperationCanceledException();
        }

        public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
            if (this.ignoreUncommittedChanges) {
                return 3;
            }
            this.encounteredDilemma = true;
            this.hasUncheckedInChanges = true;
            throw new OperationCanceledException();
        }

        public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
            return new OutOfSyncDilemmaHandler(){

                public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                    MyCreateBaselineDilemmaHandler.this.encounteredDilemma = true;
                    MyCreateBaselineDilemmaHandler.this.isOutOfSync = true;
                    throw new OperationCanceledException();
                }
            };
        }
    }
}

