/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.CLIBackupHandler;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.operations.ISuspendOperation;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;

public class SuspendCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        int maxChanges = -1;
        int uncheckedInChanges = 2;
        ICommandLine subargs = config.getSubcommandCommandLine();
        if (!subargs.hasOption((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS)) {
            throw StatusHelper.argSyntax((String)Messages.SuspendCmd_0);
        }
        List csSelectors = subargs.getOptions((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS);
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        maxChanges = CommonOptions.getMaxChangesToInterpret((ICommandLine)subargs);
        uncheckedInChanges = CommonOptions.getUncheckedInChanges((ICommandLine)subargs);
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        List workspaces = RepoUtil.getWorkspaceConnections((ICopyFileAreaView)cfaView, (boolean)false);
        HashMap<IWorkspaceConnection, List> changeSets = new HashMap<IWorkspaceConnection, List>();
        for (String string : csSelectors) {
            HashMap<IWorkspaceConnection, List> changeSetsTmp = new HashMap<IWorkspaceConnection, List>();
            for (IWorkspaceConnection wsConn : workspaces) {
                try {
                    changeSetsTmp.put(wsConn, RepoUtil.findNamedChangeSetsForWorkspace((IWorkspaceConnection)wsConn, (String)string, (IClientConfiguration)config));
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.SuspendCmd_1, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
            }
            int numTmpChangesets = 0;
            for (IWorkspaceConnection wsConn : changeSetsTmp.keySet()) {
                numTmpChangesets += ((List)changeSetsTmp.get(wsConn)).size();
            }
            if (numTmpChangesets == 0) {
                RepoUtil.UnmatchedSelectorException e = new RepoUtil.UnmatchedSelectorException(RepoUtil.SelectorException.Type.CHANGESET, string, Collections.EMPTY_LIST);
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.SuspendCmd_2, (Object)e.getSelector()));
            }
            if (1 < numTmpChangesets) {
                IndentingPrintStream ps = new IndentingPrintStream((OutputStream)config.getContext().stdout());
                ps.println((CharSequence)Messages.SuspendCmd_3);
                PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
                options.setVerbose(verbose);
                options.enablePrinter(0);
                options.enablePrinter(1);
                options.enablePrinter(8);
                options.enablePrinter(4);
                options.enablePrinter(6);
                options.setMaxChanges(maxChanges);
                options.enablePrinter(7);
                options.enableFilter(0);
                options.enableFilter(1);
                options.enableFilter(4);
                for (IWorkspaceConnection wsConn : changeSetsTmp.keySet()) {
                    List changeSetsForCP;
                    options.addFilter((IItemHandle)wsConn.getResolvedWorkspace(), 0);
                    List csHandles = (List)changeSetsTmp.get(wsConn);
                    options.addFilters((Collection)csHandles, 4);
                    try {
                        changeSetsForCP = wsConn.teamRepository().itemManager().fetchPartialItems(csHandles, 0, Collections.singleton(IChangeSet.COMPONENT_PROPERTY), null);
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((String)Messages.SuspendCmd_4, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                    }
                    for (IChangeSet cs : changeSetsForCP) {
                        options.addFilter((IItemHandle)cs.getComponent(), 1);
                    }
                }
                PendingChangesUtil.printPendingChanges((boolean)false, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)ps.indent(), (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.SuspendCmd_5, (Object)string));
            }
            for (IWorkspaceConnection wsConn : changeSetsTmp.keySet()) {
                if (!changeSets.containsKey(wsConn)) {
                    changeSets.put(wsConn, (List)changeSetsTmp.get(wsConn));
                    continue;
                }
                ((List)changeSets.get(wsConn)).addAll((Collection)changeSetsTmp.get(wsConn));
            }
        }
        if (verbose) {
            IndentingPrintStream indentingPrintStream = new IndentingPrintStream((OutputStream)config.getContext().stdout());
            if (config.isDryRun()) {
                indentingPrintStream.println((CharSequence)Messages.SuspendCmd_6);
            } else {
                indentingPrintStream.println((CharSequence)Messages.SuspendCmd_7);
            }
            PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
            options.setVerbose(verbose);
            options.enablePrinter(0);
            options.enablePrinter(1);
            options.enablePrinter(8);
            options.enablePrinter(4);
            options.enablePrinter(6);
            options.setMaxChanges(maxChanges);
            options.enablePrinter(7);
            options.enableFilter(0);
            options.enableFilter(1);
            options.enableFilter(4);
            for (IWorkspaceConnection wsConn : changeSets.keySet()) {
                List changeSetsForCP;
                options.addFilter((IItemHandle)wsConn.getResolvedWorkspace(), 0);
                List csHandles = (List)changeSets.get(wsConn);
                options.addFilters((Collection)csHandles, 4);
                try {
                    changeSetsForCP = wsConn.teamRepository().itemManager().fetchPartialItems(csHandles, 0, Collections.singleton(IChangeSet.COMPONENT_PROPERTY), null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.SuspendCmd_8, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
                for (IChangeSet cs : changeSetsForCP) {
                    options.addFilter((IItemHandle)cs.getComponent(), 1);
                }
            }
            PendingChangesUtil.printPendingChanges((boolean)false, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)indentingPrintStream.indent(), (IClientConfiguration)config);
        }
        if (!config.isDryRun()) {
            for (Map.Entry entry : changeSets.entrySet()) {
                IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)entry.getKey();
                List changesetHandles = (List)entry.getValue();
                if (changesetHandles.isEmpty()) continue;
                com.ibm.team.filesystem.cli.client.internal.handler.SuspendDilemmaHandler suspendDilemmaHandler = new com.ibm.team.filesystem.cli.client.internal.handler.SuspendDilemmaHandler(uncheckedInChanges);
                ISuspendOperation suspendOperation = IOperationFactory.instance.getSuspendOperation((SuspendDilemmaHandler)suspendDilemmaHandler);
                suspendOperation.setRefreshBeforeRun(((ClientConfiguration)config).getPersistentPreferences().getAutoRefresh());
                suspendOperation.suspend(workspaceConnection, (Collection)changesetHandles);
                try {
                    suspendOperation.run(null);
                }
                catch (GapException gapException) {
                    throw StatusHelper.gap((String)Messages.SuspendCmd_9);
                }
                catch (NWayConflictUnsupportedException nWayConflictUnsupportedException) {
                    throw StatusHelper.nWayConflict((String)Messages.SuspendCmd_10);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.SuspendCmd_11, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
                catch (OperationCanceledException e) {
                    suspendDilemmaHandler.throwExceptions();
                    throw e;
                }
                if (suspendDilemmaHandler.backupHandler.getSaved().size() <= 0) continue;
                SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()), (CLIBackupHandler)suspendDilemmaHandler.backupHandler);
            }
            config.getContext().stdout().println(Messages.SuspendCmd_CHANGESETS_SUCCESSFULLY_SUSPENDED);
        }
    }
}

