/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ResumeCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAcceptChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsStructuredResultOptions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredWorkspaceUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ActiveChangeSetsException;
import com.ibm.team.scm.common.ActiveChangeSetsOverlapException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResumeCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        WorkspaceUpdateResultDTO result;
        ISandbox[] sandboxes = config.getSandboxes();
        IFilesystemRestClient client = SubcommandUtil.startDaemon((ISandbox[])sandboxes, (IClientConfiguration)config);
        SubcommandUtil.registerSandboxes((IFilesystemRestClient)client, (ISandbox[])sandboxes, (IClientConfiguration)config);
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
        ICommandLine subcmd = config.getSubcommandCommandLine();
        ParmsWorkspaceUpdate parms = new ParmsWorkspaceUpdate();
        String targetSelector = subcmd.getOption(CommonOptions.OPT_STREAM_TARGET_SELECTOR, null);
        ArrayList<ParmsWorkspace> targetWs = new ArrayList<ParmsWorkspace>(1);
        if (targetSelector == null) {
            ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
            for (ICopyFileAreaView.IRepoView repoView : cfaView.getLoadedWorkspaces()) {
                ParmsWorkspace parm = new ParmsWorkspace();
                parm.repositoryUrl = repoView.getURI();
                parm.workspaceItemId = repoView.getHandle().getItemId().getUuidValue();
                targetWs.add(parm);
            }
        } else {
            IWorkspace wsHandle;
            try {
                wsHandle = RepoUtil.findNamedWorkspace((String)targetSelector, (boolean)true, (boolean)false, (ITeamRepository)repo, (IClientConfiguration)config);
            }
            catch (RepoUtil.UnmatchedSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ResumeCmd_8, (Object)e.getSelector()));
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ResumeCmd_9, (Object)e.getSelector()));
            }
            ParmsWorkspace parm = new ParmsWorkspace();
            parm.repositoryUrl = repo.getRepositoryURI();
            parm.workspaceItemId = wsHandle.getItemId().getUuidValue();
            targetWs.add(parm);
        }
        if (targetWs.size() != 1) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ResumeCmd_7, (Object)subcmd.getDefinition().getOption(CommonOptions.OPT_STREAM_TARGET_SELECTOR).getName()));
        }
        this.generateResumeParms(config, client, subcmd, sandboxes, parms, (ParmsWorkspace)targetWs.get(0));
        if (config.isDryRun()) {
            return;
        }
        try {
            result = client.postWorkspaceUpdate(parms, null);
        }
        catch (TeamRepositoryException e) {
            if (this.isActiveChangeSetsException(e)) {
                throw StatusHelper.disallowed((String)Messages.ResumeCmd_0);
            }
            PermissionDeniedException pde = this.findExceptionByType(PermissionDeniedException.class, e);
            if (pde != null) {
                throw StatusHelper.permissionFailure((TeamRepositoryException)pde, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            GapException gap = this.findExceptionByType(GapException.class, e);
            if (gap != null) {
                throw StatusHelper.gap((String)Messages.ResumeCmd_1);
            }
            NWayConflictUnsupportedException nway = this.findExceptionByType(NWayConflictUnsupportedException.class, e);
            if (nway != null) {
                throw StatusHelper.nWayConflict((String)Messages.ResumeCmd_2);
            }
            ActiveChangeSetsOverlapException overlap = this.findExceptionByType(ActiveChangeSetsOverlapException.class, e);
            if (overlap != null) {
                throw StatusHelper.disallowed((String)Messages.ResumeCmd_11);
            }
            throw StatusHelper.wrap((String)Messages.ResumeCmd_3, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        if (result.isCancelled() && result.getConfigurationsWithUnCheckedInChanges().size() > 0) {
            throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.ResumeCmd_UNCOMMITTED_COMPLAINT, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
        }
        IndentingPrintStream ps = new IndentingPrintStream((OutputStream)config.getContext().stdout());
        ps.println((CharSequence)Messages.ResumeCmd_CS_RESUME);
        AcceptResultDisplayer.showResult(repo, false, result, subcmd.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE), config);
        if (this.hasConflicts(result)) {
            throw StatusHelper.conflict((String)Messages.ResumeCmd_4);
        }
    }

    private boolean hasConflicts(WorkspaceUpdateResultDTO result) {
        for (StructuredWorkspaceUpdateReportDTO wsReport : result.getStructuredResult()) {
            if (!wsReport.isHasConflicts()) continue;
            return true;
        }
        return false;
    }

    private boolean isActiveChangeSetsException(TeamRepositoryException e) {
        int tries = 0;
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ActiveChangeSetsException)) continue;
            return true;
        }
        return false;
    }

    private <T> T findExceptionByType(Class<T> type, TeamRepositoryException e) {
        int tries = 0;
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!type.isInstance(cause)) continue;
            return type.cast(cause);
        }
        return null;
    }

    private void generateResumeParms(IClientConfiguration config, IFilesystemRestClient client, ICommandLine subcmd, ISandbox[] sandboxes, ParmsWorkspaceUpdate parms, ParmsWorkspace targetWs) throws FileSystemClientException {
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IClientConfiguration)config);
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
        SubcommandUtil.loginToClient((IClientConfiguration)config, (ITeamRepository)repo, (IFilesystemRestClient)client);
        List selectors = Collections.EMPTY_LIST;
        if (subcmd.hasOption((IOptionKey)ResumeCmdOptions.OPT_SELECTORS)) {
            selectors = subcmd.getOptions((IOptionKey)ResumeCmdOptions.OPT_SELECTORS);
        }
        parms.structuredResultOptions = new ParmsStructuredResultOptions();
        parms.workspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        parms.workspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parms.pendingChangesDilemmaHandler.pendingChangesInstruction = subcmd.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
        if (selectors.size() <= 0) {
            throw StatusHelper.internalError((String)Messages.ResumeCmd_5);
        }
        ParmsAcceptChangeSets update = new ParmsAcceptChangeSets();
        update.changeSetItemIds = ResumeCmd.normalizeCsUuidAndAlias(repo, selectors, config);
        update.workspace = targetWs;
        parms.acceptChangeSets = new ParmsAcceptChangeSets[]{update};
    }

    private static String[] normalizeCsUuidAndAlias(ITeamRepository repo, List<String> csSelectors, IClientConfiguration config) throws FileSystemClientException {
        String[] normalized = new String[csSelectors.size()];
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        List susp = Collections.EMPTY_LIST;
        try {
            workspaceManager.refresh(null);
            List suspended = workspaceManager.suspendedChangeSets();
            susp = repo.itemManager().fetchCompleteItems(suspended, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ResumeCmd_10, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        int i = 0;
        while (i < normalized.length) {
            String selector = csSelectors.get(i);
            UUID uuid = RepoUtil.lookupUuid((String)selector);
            if (uuid != null) {
                normalized[i] = uuid.getUuidValue();
            } else {
                ArrayList<IChangeSet> matches = new ArrayList<IChangeSet>();
                for (IChangeSet c : susp) {
                    if (!c.getComment().equals(selector)) continue;
                    matches.add(c);
                }
                if (matches.size() == 1) {
                    normalized[i] = ((IChangeSet)matches.get(0)).getItemId().getUuidValue();
                } else {
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ResumeCmd_6, (Object)selector));
                }
            }
            ++i;
        }
        return normalized;
    }
}

