/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommentCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.io.OutputStream;
import org.eclipse.osgi.util.NLS;

public class ChangesetCommentCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        IChangeSetHandle csHandle;
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
        ICommandLine cli = config.getSubcommandCommandLine();
        try {
            csHandle = RepoUtil.findNamedChangeSet((ITeamRepository)repo, (String)cli.getOption(ChangesetCommonOptions.OPT_CHANGESET.getId()), (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetCommentCmd_0, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetCommentCmd_1, (Object)e.getSelector()));
        }
        try {
            SCMPlatform.getWorkspaceManager((ITeamRepository)repo).setComment(csHandle, cli.getOption(ChangesetCommentCmdOptions.OPT_COMMENT.getId()), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangesetCommentCmd_2, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        config.getContext().stdout().println(Messages.ChangesetCommentCmd_3);
    }
}

