/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ChangesetCloseCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        List csHandles;
        ICommandLine cli = config.getSubcommandCommandLine();
        String uri = cli.getOption((IOptionKey)CommonOptions.OPT_URI, null);
        String wsSelector = cli.getOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null);
        IWorkspaceConnection wsConn = RepoUtil.findWorkspaceConnection((IClientConfiguration)config, (String)uri, (String)wsSelector);
        String csSelector = cli.getOption(ChangesetCommonOptions.OPT_CHANGESET.getId());
        try {
            csHandles = RepoUtil.findNamedChangeSetsForWorkspace((IWorkspaceConnection)wsConn, (String)csSelector, (IClientConfiguration)config);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        if (csHandles.size() == 0) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetCloseCmd_7, (Object)csSelector));
        }
        if (csHandles.size() > 1) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetCloseCmd_8, (Object)csSelector));
        }
        try {
            wsConn.ensureClosed(Collections.singletonList((IChangeSetHandle)csHandles.get(0)), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangesetCloseCmd_9, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        config.getContext().stdout().println(Messages.ChangesetCloseCmd_10);
    }
}

