/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.workingcopy;

import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopyFactory;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopyManager;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;

class WorkingCopyManager
implements IWorkingCopyManager {
    private static WorkingCopyManager instance;
    private HashMap mapFactoryToWorkingCopyStruct = new HashMap();

    WorkingCopyManager() {
    }

    public IWorkingCopy allocate(IWorkingCopyFactory factory) throws CoreException {
        WorkingCopyStruct struct = (WorkingCopyStruct)this.mapFactoryToWorkingCopyStruct.get(factory);
        if (struct == null) {
            struct = new WorkingCopyStruct(factory.createWorkingCopy(), 0);
            this.mapFactoryToWorkingCopyStruct.put(factory, struct);
        }
        ++struct.refcount;
        return struct.copy;
    }

    public void deallocate(IWorkingCopyFactory factory) {
        WorkingCopyStruct struct = (WorkingCopyStruct)this.mapFactoryToWorkingCopyStruct.get(factory);
        if (struct == null) {
            return;
        }
        --struct.refcount;
        if (struct.refcount == 0) {
            struct.copy.dispose();
            this.mapFactoryToWorkingCopyStruct.remove(factory);
        }
    }

    public static WorkingCopyManager getInstance() {
        if (instance == null) {
            instance = new WorkingCopyManager();
        }
        return instance;
    }

    private static final class WorkingCopyStruct {
        IWorkingCopy copy;
        int refcount;

        public WorkingCopyStruct(IWorkingCopy copy2, int i) {
            this.copy = copy2;
            this.refcount = i;
        }
    }
}

