/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.workingcopy;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.viewers.ChoiceEnumeration;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopyManager;
import com.ibm.team.repository.rcp.ui.workingcopy.SaveConflictException;
import com.ibm.team.repository.rcp.ui.workingcopy.WorkingCopyManager;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingCopies {
    private WorkingCopies() {
    }

    public static IWorkingCopyManager getWorkingCopyManager() {
        return WorkingCopyManager.getInstance();
    }

    public static boolean performSave(Shell currentShell, IWorkingCopy input, IProgressMonitor mon) {
        return WorkingCopies.performSave(currentShell, Collections.singleton(input), mon);
    }

    public static boolean performSave(Shell currentShell, Collection<IWorkingCopy> input, IProgressMonitor mon) {
        try {
            WorkingCopies.performSaveThrowExceptions(currentShell, input, mon);
            return true;
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                return false;
            }
            MessageDialogFactory.showMessage(currentShell, StatusUtil.newStatus(WorkingCopies.class, (Throwable)e));
            return false;
        }
    }

    public static void performSaveThrowExceptions(Shell currentShell, Collection<IWorkingCopy> inputs, IProgressMonitor monitor) throws CoreException {
        SubMonitor childProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)inputs.size());
        int i = 0;
        for (IWorkingCopy next : inputs) {
            try {
                next.save((IProgressMonitor)childProgress.newChild(1));
            }
            catch (SaveConflictException saveConflictException) {
                final Object[] _result = new Object[1];
                Parts.openModalDialog(currentShell, new IPartResult(){

                    public void setResult(Object result) {
                        _result[0] = result;
                    }
                }, new MessageDialogFactory(new ChoiceEnumeration().add(MessageDialogFactory.YES).add(MessageDialogFactory.NO).add(MessageDialogFactory.CANCEL), MessageDialogFactory.getImageForType(2), Messages.WorkingCopies_0, NLS.bind((String)Messages.WorkingCopies_1, (Object)next.getName())));
                if (_result[0].equals(MessageDialogFactory.YES.getValue())) {
                    childProgress.setWorkRemaining(inputs.size() - i);
                    next.saveAndOverwrite((IProgressMonitor)childProgress.newChild(1));
                }
                if (_result[0].equals(MessageDialogFactory.NO.getValue())) {
                    childProgress.setWorkRemaining(inputs.size() - i);
                    next.revert((IProgressMonitor)childProgress.newChild(1));
                }
                throw new CoreException(Status.CANCEL_STATUS);
            }
            ++i;
        }
    }
}

