/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.wizards;

import com.ibm.team.repository.rcp.ui.wizards.PageChainSite;
import com.ibm.team.repository.rcp.ui.wizards.ProxyPage;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChainedWizard
extends Wizard {
    private PageChainSite site = new PageChainSite(){

        public void addPage(IWizardPage page) {
            ChainedWizard.this.addPage(page);
        }

        public void pageOrderChanged() {
            if (!ChainedWizard.this.initialized) {
                return;
            }
            ChainedWizard.this.getContainer().updateButtons();
        }

        public void removePage(IWizardPage page) {
        }
    };
    private boolean initialized = false;
    ProxyPage proxyPage = new ProxyPage("proxy");

    public ChainedWizard() {
        this.proxyPage.setWizard((IWizard)this);
    }

    public void addPage(IWizardPage page) {
        super.addPage(page);
    }

    public void setContainer(IWizardContainer wizardContainer) {
        if (wizardContainer == null) {
            super.setContainer(null);
        } else if (!this.initialized) {
            super.setContainer((IWizardContainer)new WrapperContainer(wizardContainer));
        } else {
            this.superSetContainer(wizardContainer);
        }
    }

    private void superSetContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
    }

    public void createPageControls(Composite pageContainer) {
        if (this.initialized) {
            return;
        }
        super.createPageControls(pageContainer);
        this.initialized();
    }

    protected final void initialized() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.proxyPage.setRealPage(this.getStartingPage());
    }

    public IWizardContainer getWrappedContainer() {
        if (this.getContainer() instanceof WrapperContainer) {
            WrapperContainer wc = (WrapperContainer)this.getContainer();
            return wc.realContainer;
        }
        return this.getContainer();
    }

    public boolean canFinish() {
        if (!this.initialized) {
            return false;
        }
        List<IWizardPage> pages = this.getPageOrder();
        for (IWizardPage next : pages) {
            if (next.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public void addPages() {
        super.addPages();
    }

    public boolean performFinish() {
        return false;
    }

    public abstract List<IWizardPage> getPageOrder();

    protected final PageChainSite getPageChainSite() {
        return this.site;
    }

    public final IWizardPage getNextPage(IWizardPage page) {
        if (!this.initialized) {
            return null;
        }
        if (page == this.proxyPage) {
            return this.getNextPage(this.getStartingPage());
        }
        List<IWizardPage> pages = this.getPageOrder();
        int idx = pages.indexOf(page);
        if (idx >= 0 && idx < pages.size() - 1) {
            return pages.get(idx + 1);
        }
        return null;
    }

    public final IWizardPage getPreviousPage(IWizardPage page) {
        if (!this.initialized) {
            return null;
        }
        if (page == this.proxyPage) {
            return null;
        }
        List<IWizardPage> pages = this.getPageOrder();
        int idx = pages.indexOf(page);
        if (idx >= 1 && idx < pages.size()) {
            return pages.get(idx - 1);
        }
        return null;
    }

    public final IWizardPage getStartingPage() {
        if (!this.initialized) {
            if (super.getStartingPage() != null) {
                return this.proxyPage;
            }
            return null;
        }
        List<IWizardPage> pages = this.getPageOrder();
        if (pages.isEmpty()) {
            return null;
        }
        return pages.get(0);
    }

    public final IWizardPage[] getPages() {
        return super.getPages();
    }

    public final int getPageCount() {
        if (!this.initialized) {
            return super.getPageCount();
        }
        return this.getPageOrder().size();
    }

    private class WrapperContainer
    implements IWizardContainer2 {
        private IWizardContainer realContainer;

        public WrapperContainer(IWizardContainer wc) {
            this.realContainer = wc;
        }

        public void updateSize() {
            if (this.realContainer instanceof IWizardContainer2) {
                ((IWizardContainer2)this.realContainer).updateSize();
            }
        }

        public IWizardPage getCurrentPage() {
            IWizardPage wizardPage;
            if (this.realContainer == null) {
                return null;
            }
            IWizardPage pg = this.realContainer.getCurrentPage();
            if (pg == ChainedWizard.this.proxyPage && (wizardPage = ChainedWizard.this.proxyPage.getRealPage()) != null) {
                return wizardPage;
            }
            return pg;
        }

        public Shell getShell() {
            return this.realContainer.getShell();
        }

        public void showPage(IWizardPage page) {
            IWizardPage realPage;
            if (page == ChainedWizard.this.proxyPage && (realPage = ChainedWizard.this.proxyPage.getRealPage()) != null) {
                page = realPage;
            }
            if (page != ChainedWizard.this.proxyPage) {
                ChainedWizard.this.setContainer(this.realContainer);
            }
            this.realContainer.showPage(page);
        }

        public void updateButtons() {
            this.realContainer.updateButtons();
        }

        public void updateMessage() {
            this.realContainer.updateMessage();
        }

        public void updateTitleBar() {
            this.realContainer.updateTitleBar();
        }

        public void updateWindowTitle() {
            this.realContainer.updateWindowTitle();
        }

        public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
            this.realContainer.run(fork, cancelable, runnable);
        }
    }
}

