/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.utils;

import com.ibm.team.repository.rcp.ui.internal.parts.NullMnemonicGenerator;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.wizards.WizardPageJobRunner;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchPart;

public final class WidgetFactoryContext {
    private WidgetToolkit formToolkit;
    private MnemonicGenerator mnemonicGenerator;
    private IOperationRunner backgroundOperationRunner;
    private IOperationRunner userOperationRunner;

    private WidgetFactoryContext(WidgetToolkit toolkit, MnemonicGenerator mnemonicGenerator, IOperationRunner backgroundOperationRunner, IOperationRunner userOperationRunner) {
        this.formToolkit = toolkit;
        this.mnemonicGenerator = mnemonicGenerator;
        this.backgroundOperationRunner = backgroundOperationRunner;
        this.userOperationRunner = userOperationRunner;
    }

    public WidgetToolkit getToolkit() {
        return this.formToolkit;
    }

    public MnemonicGenerator getMnemonics() {
        return this.mnemonicGenerator;
    }

    public static WidgetFactoryContext forDialogBox() {
        return new WidgetFactoryContext(WidgetToolkit.createSwtToolkit(), new MnemonicGenerator(true), new JobRunner(false), new JobRunner(true));
    }

    public static WidgetFactoryContext forWorkbenchPart(IWorkbenchPart part) {
        return new WidgetFactoryContext(WidgetToolkit.createFormToolkit(), new MnemonicGenerator(new NullMnemonicGenerator()), new PartSiteJobRunner(part.getSite(), false), new PartSiteJobRunner(part.getSite(), true));
    }

    public static WidgetFactoryContext forWizardPage(IWizardPage page) {
        return new WidgetFactoryContext(WidgetToolkit.createSwtToolkit(), MnemonicGenerator.forWizardPage(), new JobRunner(false), new WizardPageJobRunner(page.getWizard().getContainer()));
    }

    public static WidgetFactoryContext forPreferencePage(IPreferencePage preferencePage, String[] applyAndDefaultLabels) {
        return new WidgetFactoryContext(WidgetToolkit.createSwtToolkit(), MnemonicGenerator.forPreferencePage(applyAndDefaultLabels), new JobRunner(false), new JobRunner(true));
    }

    public static WidgetFactoryContext create(WidgetToolkit toolkit, MnemonicGenerator generator, IOperationRunner backgroundOperationRunner, IOperationRunner userOperationRunner) {
        return new WidgetFactoryContext(toolkit, generator.newChild(), backgroundOperationRunner, userOperationRunner);
    }

    public IOperationRunner getBackgroundOperationRunner() {
        return this.backgroundOperationRunner;
    }

    public IOperationRunner getUserOperationRunner() {
        return this.userOperationRunner;
    }
}

