/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts.impl;

import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.InputPart;

public final class InputPartFactory
implements IPartFactory {
    private String title;
    private String[] inputs;
    private String[] initialValue;
    private boolean[] allowBlanks;

    public InputPartFactory(String title, String[] inputs) {
        this.title = title;
        this.inputs = inputs;
        this.allowBlanks = new boolean[inputs.length];
        this.initialValue = new String[this.allowBlanks.length];
        int i = 0;
        while (i < inputs.length) {
            this.initialValue[i] = "";
            ++i;
        }
    }

    public InputPartFactory setInitialValue(int index, String initialValue) {
        if (index >= this.allowBlanks.length) {
            return this;
        }
        this.initialValue[index] = initialValue;
        return this;
    }

    public InputPartFactory allowBlanks(int index, boolean allow) {
        if (index >= this.allowBlanks.length) {
            return this;
        }
        this.allowBlanks[index] = allow;
        return this;
    }

    public AbstractPart createPart(IControlSite site, Object initialInput) {
        site.getNameable().setName(this.title);
        return new InputPart(site, this.inputs, (IPartResult)initialInput, this.allowBlanks, this.initialValue);
    }
}

