/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts;

import com.ibm.team.repository.rcp.ui.parts.DefaultSwtToolkit;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WidgetToolkit {
    private IRunnableWithResult<FormToolkit> toolkitFactory;
    private int referenceCount = 0;
    private FormToolkit toolkit;
    private DisposeListener dl = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            WidgetToolkit.this.decRef();
        }
    };
    private static final String TRACKED_DATA = String.valueOf(WidgetToolkit.class.getName()) + ".tracked";

    public static WidgetToolkit create(IRunnableWithResult<FormToolkit> ft) {
        return new WidgetToolkit(ft);
    }

    private WidgetToolkit(IRunnableWithResult<FormToolkit> ft) {
        this.toolkitFactory = ft;
    }

    private FormToolkit incRef() {
        if (this.referenceCount == 0) {
            this.toolkit = this.toolkitFactory.run();
        }
        ++this.referenceCount;
        return this.toolkit;
    }

    private void decRef() {
        if (this.referenceCount > 0) {
            --this.referenceCount;
            if (this.referenceCount == 0) {
                this.toolkit.dispose();
                this.toolkit = null;
            }
        }
    }

    public Button createButton(Composite parent, String text, int style) {
        return this.track(this.incRef().createButton(parent, text, style));
    }

    private <T extends Widget> T track(T toTrack) {
        if (toTrack.getData(TRACKED_DATA) != null) {
            this.decRef();
            return toTrack;
        }
        toTrack.setData(TRACKED_DATA, (Object)TRACKED_DATA);
        toTrack.addDisposeListener(this.dl);
        return toTrack;
    }

    public Composite createComposite(Composite parent) {
        return this.track(this.incRef().createComposite(parent));
    }

    public Composite createComposite(Composite parent, int style) {
        return this.track(this.incRef().createComposite(parent, style));
    }

    public Composite createCompositeSeparator(Composite parent) {
        return this.track(this.incRef().createCompositeSeparator(parent));
    }

    public Label createLabel(Composite parent, String text) {
        return this.track(this.incRef().createLabel(parent, text));
    }

    public Label createLabel(Composite parent, String text, int style) {
        return this.track(this.incRef().createLabel(parent, text, style));
    }

    public Hyperlink createHyperlink(Composite parent, String text, int style) {
        return this.track(this.incRef().createHyperlink(parent, text, style));
    }

    public ImageHyperlink createImageHyperlink(Composite parent, int style) {
        return this.track(this.incRef().createImageHyperlink(parent, style));
    }

    public FormText createFormText(Composite parent, boolean trackFocus) {
        return this.track(this.incRef().createFormText(parent, trackFocus));
    }

    public void adapt(Control control, boolean trackFocus, boolean trackKeyboard) {
        this.incRef().adapt(control, trackFocus, trackKeyboard);
        this.track(control);
    }

    public void adapt(Composite composite) {
        this.incRef().adapt(composite);
        this.track(composite);
    }

    public Section createSection(Composite parent, int sectionStyle) {
        return this.track(this.incRef().createSection(parent, sectionStyle));
    }

    public ExpandableComposite createExpandableComposite(Composite parent, int expansionStyle) {
        return this.track(this.incRef().createExpandableComposite(parent, expansionStyle));
    }

    public Label createSeparator(Composite parent, int style) {
        return this.track(this.incRef().createSeparator(parent, style));
    }

    public Table createTable(Composite parent, int style) {
        return this.track(this.incRef().createTable(parent, style));
    }

    public Text createText(Composite parent, String value) {
        return this.track(this.incRef().createText(parent, value));
    }

    public Text createText(Composite parent, String value, int style) {
        return this.track(this.incRef().createText(parent, value, style));
    }

    public Tree createTree(Composite parent, int style) {
        return this.track(this.incRef().createTree(parent, style));
    }

    public ScrolledForm createScrolledForm(Composite parent) {
        return this.track(this.incRef().createScrolledForm(parent));
    }

    public Form createForm(Composite parent) {
        return this.track(this.incRef().createForm(parent));
    }

    public void decorateFormHeading(Form form) {
        this.incRef().decorateFormHeading(form);
        this.track(form);
    }

    public ScrolledPageBook createPageBook(Composite parent, int style) {
        return this.track(this.incRef().createPageBook(parent, style));
    }

    public void paintBordersFor(Composite parent) {
        this.incRef().paintBordersFor(parent);
        this.track(parent);
    }

    public static WidgetToolkit createFormToolkit() {
        return WidgetToolkit.create(new IRunnableWithResult<FormToolkit>(){

            @Override
            public FormToolkit run() {
                return new FormToolkit(Display.getCurrent());
            }
        });
    }

    public static WidgetToolkit createSwtToolkit() {
        return WidgetToolkit.create(new IRunnableWithResult<FormToolkit>(){

            @Override
            public FormToolkit run() {
                return new DefaultSwtToolkit();
            }
        });
    }
}

