/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.internal.parts.ConvertingPartSite;
import com.ibm.team.repository.rcp.ui.internal.parts.EditorHostInput;
import com.ibm.team.repository.rcp.ui.internal.parts.PageViewRegistry;
import com.ibm.team.repository.rcp.ui.internal.parts.ViewId;
import com.ibm.team.repository.rcp.ui.internal.parts.WizardPageHost;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.IPartSite;
import com.ibm.team.repository.rcp.ui.parts.IReusablePart;
import com.ibm.team.repository.rcp.ui.parts.PartDialog;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public final class Parts {
    public static void openEditor(IWorkbenchPage where, Object _input, IPartFactory factory) {
        EditorHostInput input = new EditorHostInput(_input, factory);
        try {
            where.openEditor((IEditorInput)input, "com.ibm.team.repository.rcp.ui.parts.editorHost");
        }
        catch (PartInitException e) {
            RepositoryUiPlugin.log(e);
        }
    }

    public static IWizardPage createWizardPage(Object input, IPartFactory factory, String partName, ImageDescriptor titleImageOrNull) {
        return new WizardPageHost(partName, titleImageOrNull, input, factory);
    }

    public static Shell openDialog(Shell parent, Object input, IPartFactory factory) {
        return Parts.openDialog(parent, input, factory, 3184);
    }

    public static Shell openDialog(Shell parent, Object input, IPartFactory factory, int shellStyle) {
        PartDialog d = new PartDialog(factory, input, parent, shellStyle);
        d.open();
        return d.getShell();
    }

    public static Shell openOnTop(Object input, IPartFactory factory, int shellStyle) {
        PartDialog dialog = new PartDialog(factory, input, null, shellStyle | 0x4000);
        Display display = Display.getCurrent();
        Monitor m = display.getMonitors()[0];
        Shell activeShell = display.getActiveShell();
        if (activeShell != null) {
            m = activeShell.getMonitor();
        }
        Point centerPoint = Geometry.centerPoint((Rectangle)m.getClientArea());
        Point size = dialog.getShell().computeSize(-1, -1, false);
        Point halfSize = Geometry.divide((Point)size, (int)2);
        Rectangle bounds = Geometry.createRectangle((Point)Geometry.subtract((Point)centerPoint, (Point)halfSize), (Point)size);
        dialog.getShell().setBounds(bounds);
        dialog.open();
        return dialog.getShell();
    }

    public static IViewPart openViewAndReveal(IWorkbenchPage where, Object input, String viewId, ISelection selection) {
        IViewPart thePart = Parts.openView(where, input, viewId);
        if (thePart != null) {
            thePart.getSite().getSelectionProvider().setSelection(selection);
        }
        return thePart;
    }

    public static IViewPart openView(IWorkbenchPage where, Object input, String viewId) {
        IViewPart viewPart;
        PageViewRegistry pvr = PageViewRegistry.findRegistryForPage(where);
        ViewId existingPart = pvr.findViewForInput(viewId, input);
        if (existingPart == null) {
            existingPart = pvr.generateViewId(viewId);
        }
        pvr.addView(existingPart);
        try {
            viewPart = existingPart.activate(where);
        }
        catch (PartInitException e) {
            StatusUtil.log(Parts.class, (Throwable)e);
            return null;
        }
        IReusablePart reusablePart = (IReusablePart)viewPart.getAdapter(IReusablePart.class);
        if (reusablePart != null) {
            reusablePart.setInput(input);
            pvr.setInput(existingPart, input);
        }
        return viewPart;
    }

    public static void openModalDialog(Shell parent, Object input, IPartFactory factory) {
        PartDialog d = new PartDialog(factory, input, parent, 35952);
        d.open();
        Display display = Display.getCurrent();
        Shell loopShell = d.getShell();
        while (!loopShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.update();
    }

    public static IPartSite createSite(Composite parent, IWorkbenchPart toConvert) {
        return new ConvertingPartSite(parent, toConvert);
    }

    public static Shell openOnTop(Object input, PartFactory factory) {
        return Parts.openOnTop(input, factory, 3312);
    }
}

