/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts;

import com.ibm.team.repository.rcp.core.utils.ClassIdentifier;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.IPartSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.osgi.framework.Bundle;

public class PartFactory
extends PlatformObject
implements IPartFactory,
IPersistableElement {
    private ClassIdentifier classId = null;
    private Class targetClass = null;

    public PartFactory(Class toCreateByReflection, Bundle plugin) {
        this.targetClass = toCreateByReflection;
        this.classId = new ClassIdentifier(plugin.getSymbolicName(), toCreateByReflection.getName());
    }

    public PartFactory(Class toCreateByReflection) {
        this.targetClass = toCreateByReflection;
        this.classId = new ClassIdentifier(this.targetClass);
    }

    public PartFactory(ClassIdentifier classId) {
        this.classId = classId;
    }

    public static AbstractPart createPart(Class toCreate, IControlSite site, Object input) {
        Class implementation = toCreate;
        if (!AbstractPart.class.isAssignableFrom(implementation)) {
            throw new RuntimeException(PartFactory.formatError(toCreate, NLS.bind((String)"{0} is not an instance of {1}", (Object)implementation.getClass().getName(), (Object)AbstractPart.class.getName())));
        }
        Constructor<?> targetConstructor = null;
        Class<?> siteClass = site.getClass();
        Constructor<?>[] constructors = implementation.getConstructors();
        ArrayList<String> inputTypes = new ArrayList<String>();
        int i = 0;
        while (i < constructors.length) {
            Constructor<?> constructor = constructors[i];
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length == 2 && params[0].isAssignableFrom(siteClass)) {
                inputTypes.add(params[1].getName());
                if (input == null || params[1].isAssignableFrom(input.getClass())) {
                    targetConstructor = constructor;
                }
            }
            ++i;
        }
        if (targetConstructor == null) {
            if (inputTypes.isEmpty()) {
                throw new RuntimeException(PartFactory.formatError(toCreate, NLS.bind((String)"This class needs a constructor that takes an {0} as its first argument", IPartSite.class)));
            }
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            for (String next : inputTypes) {
                if (!first) {
                    buf.append(", ");
                }
                buf.append(next);
            }
            throw new RuntimeException(PartFactory.formatError(toCreate, NLS.bind((String)"A {0} was given as input. This class accepts one of the following: {1}. To add an input type, add a constructor that takes a site as its first argument and the correct input type as the second argument.", (Object)(input == null ? "null" : input.getClass().getName()), (Object)buf.toString())));
        }
        try {
            return (AbstractPart)targetConstructor.newInstance(site, input);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(PartFactory.formatError(toCreate, NLS.bind((String)"The constructor must be public in class {0}", (Object)implementation.getName())));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)cause;
                throw re;
            }
            throw new RuntimeException(cause);
        }
    }

    public AbstractPart createPart(IControlSite site, Object input) {
        Class targetClass = this.targetClass;
        if (targetClass == null) {
            try {
                targetClass = this.classId.loadClass();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return PartFactory.createPart(targetClass, site, input);
    }

    private static String formatError(Class classId, String string) {
        return NLS.bind((String)"Error creating {0}: {1}", (Object)classId.getName(), (Object)string);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.classId = new ClassIdentifier(config.getNamespace(), (String)data);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PartFactory) {
            PartFactory factory = (PartFactory)obj;
            return factory.classId.equals((Object)this.classId);
        }
        return false;
    }

    public int hashCode() {
        return this.classId.hashCode();
    }

    public String getFactoryId() {
        return "com.ibm.team.repository.rcp.ui.partFactoryFactory";
    }

    public void saveState(IMemento memento) {
        memento.putString("class", this.classId.getTypeName());
        memento.putString("namespace", this.classId.getNamespace());
    }
}

