/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.operations;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.OperationState;
import com.ibm.team.repository.rcp.ui.operations.StatusCollector;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;

public final class RetryQueue
implements IOperationRunner {
    private HashMap queryNames = new HashMap();
    private WritableSetWithListeners errors = new WritableSetWithListeners();
    private HashMap mapOperationsOntoErrors = new HashMap();
    private IOperationRunner runner;
    private Operation theOperation;
    private Display display;

    public RetryQueue(String jobName, boolean isUser) {
        this(new JobRunner(jobName, isUser));
    }

    public RetryQueue(IOperationRunner actualJobRunner) {
        this.runner = actualJobRunner;
        this.theOperation = new Operation(){

            public void run(IProgressMonitor reporter, IStatusCollector problems) throws OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)100);
                RetryQueue.this.run(progress, problems);
            }
        };
        this.display = Display.getCurrent();
    }

    public boolean hasErrors() {
        return !this.errors.toCollection().isEmpty();
    }

    public ISetWithListeners getErrors() {
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(String taskName, Operation subtask) {
        OperationState oldState = null;
        HashMap hashMap = this.queryNames;
        synchronized (hashMap) {
            if (!this.queryNames.containsKey(subtask)) {
                this.queryNames.put(subtask, taskName);
            }
            oldState = (OperationState)this.mapOperationsOntoErrors.remove(subtask);
        }
        if (oldState != null) {
            final OperationState _state = oldState;
            SWTUtil.greedyExec(this.display, new Runnable(){

                public void run() {
                    RetryQueue.this.errors.remove(_state);
                }
            });
        }
        this.runner.enqueue(taskName, this.theOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeue(Operation subtask) {
        OperationState oldState = null;
        HashMap hashMap = this.queryNames;
        synchronized (hashMap) {
            this.queryNames.remove(subtask);
            oldState = (OperationState)this.mapOperationsOntoErrors.remove(subtask);
        }
        if (oldState != null) {
            final OperationState _state = oldState;
            SWTUtil.greedyExec(this.display, new Runnable(){

                public void run() {
                    RetryQueue.this.errors.remove(_state);
                }
            });
        }
    }

    public void ignoreAllErrors() {
        Object[] errorArray = this.errors.toArray();
        int i = 0;
        while (i < errorArray.length) {
            OperationState next = (OperationState)errorArray[i];
            this.dequeue(next.getOperation());
            ++i;
        }
    }

    public void retryAllErrors() {
        Object[] errorArray = this.errors.toArray();
        int i = 0;
        while (i < errorArray.length) {
            OperationState next = (OperationState)errorArray[i];
            this.enqueue(next.getName(), next.getOperation());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(SubMonitor reporter, IStatusCollector problems) throws OperationFailedException {
        while (true) {
            String nextName;
            Operation next;
            int remain;
            HashMap hashMap = this.queryNames;
            synchronized (hashMap) {
                remain = this.queryNames.size();
                if (remain == 0) {
                    break;
                }
                next = (Operation)this.queryNames.keySet().iterator().next();
                nextName = (String)this.queryNames.remove(next);
            }
            reporter.setWorkRemaining(remain * 100);
            StatusCollector collector = new StatusCollector();
            try {
                SubMonitor subReporter = reporter.newChild(100);
                subReporter.setTaskName(nextName);
                next.run((IProgressMonitor)subReporter, collector);
                subReporter.done();
                problems.reportProblem(collector.getStatus());
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (OperationFailedException e) {
                StatusUtil.log((IStatus)e.getReason());
                collector.reportProblem(e.getReason());
                this.addFailedOperation(new OperationState(next, nextName, collector.getStatus()));
            }
            catch (RuntimeException e) {
                StatusUtil.log((Object)this, (Throwable)e);
                collector.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                this.addFailedOperation(new OperationState(next, nextName, collector.getStatus()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFailedOperation(OperationState state) {
        OperationState oldState = null;
        HashMap hashMap = this.queryNames;
        synchronized (hashMap) {
            oldState = (OperationState)this.mapOperationsOntoErrors.get(state.getOperation());
            this.mapOperationsOntoErrors.put(state.getOperation(), state);
        }
        final OperationState _oldState = oldState;
        final OperationState _state = state;
        SWTUtil.greedyExec(this.display, new Runnable(){

            public void run() {
                if (_oldState != null) {
                    RetryQueue.this.errors.remove(_oldState);
                }
                RetryQueue.this.errors.add(_state);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.runner.dequeue(this.theOperation);
        HashMap hashMap = this.queryNames;
        synchronized (hashMap) {
            this.queryNames.clear();
            this.mapOperationsOntoErrors.clear();
        }
        this.errors.clear();
    }
}

