/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.operations;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryOperation
implements Operation {
    private final Collection<ITeamRepository> repos;

    public RepositoryOperation() {
        this.repos = null;
    }

    public RepositoryOperation(ITeamRepository repo) {
        this.repos = Collections.singletonList(repo);
    }

    public RepositoryOperation(Collection<ITeamRepository> repos) {
        this.repos = repos;
    }

    @Override
    public final void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.ensureLoggedIn((IProgressMonitor)progress.newChild(5));
            this.repositoryRun((IProgressMonitor)progress.newChild(95), problems);
        }
        catch (TeamRepositoryException e) {
            throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    protected void ensureLoggedIn(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.repos != null) {
            for (ITeamRepository repo : this.repos) {
                if (repo == null || repo.loggedIn()) continue;
                repo.login(monitor);
            }
        }
    }

    public abstract void repositoryRun(IProgressMonitor var1, IStatusCollector var2) throws TeamRepositoryException, OperationFailedException;
}

