/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.openactions;

import com.ibm.team.repository.rcp.core.utils.ClassIdentifier;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.openactions.IOpenAction;
import com.ibm.team.repository.rcp.ui.openactions.IWorkbenchRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.osgi.util.NLS;

public final class OpenActionFactory
implements IExecutableExtension,
IAdapterFactory {
    private IConfigurationElement element;
    private ClassIdentifier runnableClass;
    private IWorkbenchRunnable runnable;
    private IOpenAction openAction = new IOpenAction(){

        public IWorkbenchRunnable getRunnable() {
            return OpenActionFactory.this.getRunnable();
        }
    };
    private boolean initialized;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String className;
        IConfigurationElement child;
        this.element = config;
        IConfigurationElement[] children = this.element.getChildren();
        if (children.length != 1) {
            this.throwException(config, NLS.bind((String)"{0} adapters found in the XML. OpenActionFactory expects exactly 1 adapter of type {1}", (Object)("" + children.length), (Object)IWorkbenchRunnable.class.getName()));
        }
        if (!(child = children[0]).getName().equals("adapter")) {
            this.throwException(config, NLS.bind((String)"Unknown element type {0}. Expecting one element of type {1}", (Object)child.getName(), (Object)"adapter"));
        }
        if ((className = child.getAttribute("type")) == null || !className.equals(IOpenAction.class.getName())) {
            this.throwException(config, NLS.bind((String)"OpenActionFactory expects one adapter of type {0}. Found incorrect adapter of type {1}", (Object)IOpenAction.class.getName(), (Object)className));
        }
        if (!(data instanceof String) || ((String)data).length() == 0) {
            this.throwException(config, NLS.bind((String)"OpenActionFactory needs to specify the name of an IWorkbenchRunnable class. Correct usage: '{0}:com.ibm.NameOfALabelProviderClass", (Object)OpenActionFactory.class.getName()));
        }
        this.runnableClass = new ClassIdentifier(config.getNamespace(), (String)data);
    }

    protected IWorkbenchRunnable getRunnable() {
        if (!this.initialized) {
            this.initialized = true;
            try {
                Class clazz = this.runnableClass.loadClass();
                this.runnable = (IWorkbenchRunnable)clazz.newInstance();
            }
            catch (Exception e) {
                RepositoryUiPlugin.log(e);
            }
        }
        return this.runnable;
    }

    private void throwException(IConfigurationElement config, String string) throws CoreException {
        throw new CoreException(StatusUtil.newStatus((Object)config.getNamespace(), (String)this.formatError(string)));
    }

    private String formatError(String string) {
        return NLS.bind((String)"Error in the OpenActionFactory declared in plugin {0}: {1}", (Object)this.element.getNamespace(), (Object)string);
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IOpenAction.class && this.getRunnable() != null) {
            return this.openAction;
        }
        return null;
    }

    public final Class[] getAdapterList() {
        return new Class[]{IOpenAction.class};
    }
}

