/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.labelproviders;

import com.ibm.team.jface.labelProviders.IElementRemovedListener;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Display;

public abstract class ListeningLabelProvider
extends BaseLabelProvider
implements IElementRemovedListener {
    private WritableSetWithListeners discoveredElements;
    private ISetWithListeners knownElements;
    private ISetListener<?> knownElementsListener = new ISetListener(){

        public void changed(SetDiff diff) {
            for (Object added : diff.getAdditions()) {
                ListeningLabelProvider.this.elementAdded(added);
            }
            for (Object removed : diff.getRemovals()) {
                ListeningLabelProvider.this.elementRemoved(removed);
            }
        }
    };

    public ListeningLabelProvider(ISetWithListeners knownElements) {
        if (knownElements == null) {
            this.discoveredElements = new WritableSetWithListeners();
            this.knownElements = this.discoveredElements;
        } else {
            this.knownElements = knownElements;
        }
        this.knownElements.addListener(this.knownElementsListener);
    }

    public ListeningLabelProvider() {
        this(null);
    }

    public final void updateLabel(ViewerLabel label, Object element) {
        if (this.discoveredElements != null) {
            this.discoveredElements.add(element);
        }
        this.doUpdateLabel(label, element);
    }

    protected void elementAdded(Object element) {
    }

    protected void elementRemoved(Object element) {
    }

    protected abstract void doUpdateLabel(ViewerLabel var1, Object var2);

    public final void handleElementRemoved(Object element) {
        if (this.discoveredElements != null) {
            this.discoveredElements.remove(element);
        }
    }

    protected final ISetWithListeners getKnownElements() {
        Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        return this.knownElements;
    }

    public void dispose() {
        this.knownElements.removeListener(this.knownElementsListener);
        Collection oldElements = this.knownElements.toCollection();
        for (Object next : oldElements) {
            this.elementRemoved(next);
        }
        if (this.discoveredElements != null) {
            this.discoveredElements.clear();
        }
        super.dispose();
    }
}

