/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritableSetWithListeners<E>
extends AbstractSetWithListeners<E> {
    private HashSet<E> elements = new HashSet();

    public void clear() {
        HashSet<E> removed = new HashSet<E>(this.elements);
        this.elements.clear();
        this.fireCollectionRemoved(removed);
    }

    public boolean add(Object toAdd) {
        if (this.elements.add(toAdd)) {
            this.fireAdded(toAdd);
            return true;
        }
        return false;
    }

    public boolean remove(Object toRemove) {
        if (this.elements.remove(toRemove)) {
            this.fireRemoved(toRemove);
            return true;
        }
        return false;
    }

    public void setContents(Collection<E> newContents) {
        SetDiff diff = SetDiff.computeDiff(this.elements, newContents);
        this.elements.clear();
        this.elements.addAll(newContents);
        this.fireDiff(diff);
    }

    public boolean addAll(Collection toAdd) {
        ArrayList added = new ArrayList();
        for (Object item : toAdd) {
            if (!this.elements.add(item)) continue;
            added.add(item);
        }
        this.fireCollectionAdded(added);
        return added.size() > 0;
    }

    public boolean removeAll(Collection toRemove) {
        ArrayList removed = new ArrayList();
        for (Object item : toRemove) {
            if (!this.elements.remove(item)) continue;
            removed.add(item);
        }
        this.fireCollectionRemoved(removed);
        return removed.size() > 0;
    }

    @Override
    protected Collection<E> computeElements() {
        return this.elements;
    }
}

