/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Value<T> {
    private static ThreadLocal valueStack = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return null;
        }
    };
    private Map dependentValues = null;
    private ChangeListenerList listeners = null;
    private static Object dirtyCacheFlag = new Object();
    private T cachedResult = dirtyCacheFlag;
    private boolean stale = false;

    public final synchronized T getValue() {
        Value lastValue = (Value)valueStack.get();
        if (lastValue != null) {
            if (this.dependentValues == null) {
                this.dependentValues = new WeakHashMap();
            }
            this.dependentValues.put(lastValue, null);
        }
        if (this.cachedResult == dirtyCacheFlag) {
            try {
                valueStack.set(this);
                this.stale = false;
                this.allocate();
                T newValue = this.computeValue();
                this.cachedResult = newValue;
            }
            finally {
                valueStack.set(lastValue);
            }
        } else if (this.stale && lastValue != null) {
            lastValue.makeStale();
        }
        return this.cachedResult;
    }

    protected void allocate() {
    }

    protected void deallocate() {
    }

    public final synchronized boolean isStale() {
        return this.stale;
    }

    protected final synchronized void makeStale() {
        if (!this.stale) {
            this.stale = true;
            if (this.dependentValues != null) {
                Set dependents = this.dependentValues.keySet();
                for (Value next : dependents) {
                    next.makeStale();
                }
            }
        }
    }

    protected abstract T computeValue();

    public final synchronized void addListener(IChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ChangeListenerList();
        }
        this.listeners.add(listener);
    }

    public final synchronized void removeListener(IChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    protected final synchronized void makeDirty() {
        if (this.cachedResult != dirtyCacheFlag) {
            this.cachedResult = dirtyCacheFlag;
            if (this.dependentValues != null) {
                Set dependents = this.dependentValues.keySet();
                this.dependentValues = null;
                for (Value next : dependents) {
                    next.makeDirty();
                }
            }
            this.deallocate();
            this.notifyListeners(null);
            this.handleDirty();
        }
    }

    protected void handleDirty() {
    }

    protected final synchronized void notifyListeners(Object changeEvent) {
        if (this.listeners != null) {
            this.listeners.notifyListeners((Object)this, changeEvent);
        }
    }
}

