/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IStaleListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionSet<T>
extends AbstractSetWithListeners<T>
implements IRefreshable {
    private ArrayList<ISetWithListeners> childSets = new ArrayList();
    private HashMap refCounts = new HashMap();
    private ISetListener childListener = new ISetListener(){

        public void changed(SetDiff diff) {
            UnionSet.this.processDiff(diff);
        }
    };
    private IStaleListener childStaleListener = new IStaleListener(){

        public void setStale(Object staleObject, boolean isStale) {
            UnionSet.this.processStale(isStale);
        }
    };
    private int staleCount = 0;

    @Override
    public boolean canRefresh() {
        for (ISetWithListeners next : this.childSets) {
            IRefreshable r = (IRefreshable)Adapters.getAdapter((Object)next, IRefreshable.class);
            if (r == null || !r.canRefresh()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void refresh() {
        for (ISetWithListeners next : this.childSets) {
            IRefreshable r = (IRefreshable)Adapters.getAdapter((Object)next, IRefreshable.class);
            if (r == null) continue;
            r.refresh();
        }
    }

    @Override
    protected void allocate() {
        for (ISetWithListeners next : this.childSets) {
            this.initChild(next);
        }
        super.allocate();
    }

    protected void processStale(boolean isStale) {
        this.staleCount = isStale ? ++this.staleCount : --this.staleCount;
        this.setStale(this.staleCount > 0);
    }

    @Override
    protected void deallocate() {
        for (ISetWithListeners next : this.childSets) {
            this.deinitChild(next);
        }
    }

    public void add(ISetWithListeners l) {
        boolean add = true;
        Iterator<ISetWithListeners> i = this.childSets.iterator();
        while (i.hasNext()) {
            if (i.next() != l) continue;
            add = false;
            break;
        }
        if (add) {
            this.childSets.add(l);
            if (this.isAllocated()) {
                this.initChild(l);
            }
        }
    }

    public void remove(ISetWithListeners l) {
        boolean removed = false;
        Iterator<ISetWithListeners> i = this.childSets.iterator();
        while (i.hasNext()) {
            if (i.next() != l) continue;
            i.remove();
            removed = true;
            break;
        }
        if (removed && this.isAllocated()) {
            this.deinitChild(l);
        }
    }

    private void processDiff(SetDiff<T> diff) {
        HashSet adds = new HashSet();
        Set added = diff.getAdditions();
        for (Object next : added) {
            Integer refCount = (Integer)this.refCounts.get(next);
            if (refCount == null) {
                adds.add(next);
                refCount = new Integer(1);
                this.refCounts.put(next, refCount);
                continue;
            }
            refCount = new Integer(refCount + 1);
            this.refCounts.put(next, refCount);
        }
        HashSet removes = new HashSet();
        for (Object next : diff.getRemovals()) {
            Integer refCount = (Integer)this.refCounts.get(next);
            if (refCount == null) continue;
            int refs = refCount;
            if (refs <= 1) {
                removes.add(next);
                this.refCounts.remove(next);
                continue;
            }
            refCount = new Integer(refCount - 1);
            this.refCounts.put(next, refCount);
        }
        this.fireDiff(SetDiff.create(removes, adds));
    }

    private void initChild(ISetWithListeners child) {
        child.addListener(this.childListener);
        child.addStaleListener(this.childStaleListener);
        if (child.isStale()) {
            this.processStale(true);
        }
        this.processDiff(SetDiff.createAddition(child.toCollection()));
    }

    private void deinitChild(ISetWithListeners child) {
        child.toArray();
        child.removeListener(this.childListener);
        child.removeStaleListener(this.childStaleListener);
        if (child.isStale()) {
            this.processStale(false);
        }
        this.processDiff(SetDiff.createRemoval(child.toCollection()));
    }

    @Override
    protected Collection computeElements() {
        return this.refCounts.keySet();
    }
}

