/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.jface.labelProviders.IElementRemovedListener;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.MenuManagerWithDefaultAdditions;
import com.ibm.team.repository.rcp.ui.internal.viewers.SingleElementSelectionProvider;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartLabel<T> {
    private IViewerLabelProvider labelProvider;
    private CLabel labelWidget;
    private Link linkWidget;
    private List elementRemovedListeners = new ArrayList();
    private MenuManager popupMenu;
    PrivateInterface privateInterface = new PrivateInterface();
    private SingleElementSelectionProvider selectionProvider = new SingleElementSelectionProvider();
    private T input;
    private Composite composite;
    private IPartResult<T> partResult;

    public SmartLabel(Composite parent) {
        this(parent, null);
    }

    public SmartLabel(Composite parent, IPartResult<T> partResult) {
        this.partResult = partResult;
        this.composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(this.composite);
        this.labelWidget = new CLabel(this.composite, 16384);
        this.labelWidget.addDisposeListener((DisposeListener)this.privateInterface);
        if (partResult != null) {
            this.linkWidget = new Link(this.composite, 0);
            this.linkWidget.addListener(13, (Listener)this.privateInterface);
            GC gc = new GC((Drawable)this.linkWidget);
            FontMetrics fontMetrics = gc.getFontMetrics();
            int heightHint = fontMetrics.getHeight();
            gc.dispose();
            GridDataFactory.fillDefaults().grab(false, true).hint(22, 22).applyTo((Control)this.labelWidget);
            GridDataFactory.fillDefaults().grab(true, true).hint(-1, heightHint).align(4, 0x1000000).applyTo((Control)this.linkWidget);
        } else {
            GridDataFactory.fillDefaults().grab(true, true).align(4, 0x1000000).applyTo((Control)this.labelWidget);
        }
        this.popupMenu = new MenuManagerWithDefaultAdditions();
        this.labelProvider = LabelProviders.create(this.privateInterface);
        this.labelProvider.addListener((ILabelProviderListener)this.privateInterface);
        Menu menu = this.popupMenu.createContextMenu((Control)this.labelWidget);
        this.labelWidget.setMenu(menu);
        if (this.linkWidget != null) {
            this.linkWidget.setMenu(menu);
        }
    }

    public IElementRemovedNotifier getElementRemovedNotifier() {
        return this.privateInterface;
    }

    protected void fireElementRemoved(Object element) {
        IElementRemovedListener[] listeners = this.elementRemovedListeners.toArray(new IElementRemovedListener[this.elementRemovedListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            IElementRemovedListener next = listeners[i];
            try {
                next.handleElementRemoved(element);
            }
            catch (RuntimeException e) {
                StatusUtil.log((Object)this, (String)"An unhandled exception was thrown by an IElementRemovedListener. The listener has been removed.", (Throwable)e);
                this.elementRemovedListeners.remove(e);
            }
            ++i;
        }
    }

    public void setInput(T input) {
        T oldInput = this.input;
        this.selectionProvider.setSelection(input);
        this.input = input;
        this.updateLabel();
        if (oldInput != null) {
            this.fireElementRemoved(oldInput);
        }
    }

    private void updateLabel() {
        String oldText;
        ViewerLabel label = new ViewerLabel("", null);
        if (this.input != null) {
            this.labelProvider.updateLabel(label, this.input);
        }
        if (this.labelWidget.getImage() != label.getImage()) {
            this.labelWidget.setImage(label.getImage());
        }
        if (!NullUtil.equals((Object)(oldText = this.getText()), (Object)label.getText())) {
            if (this.linkWidget != null) {
                this.linkWidget.setText("<a>" + label.getText() + "</a>");
            } else {
                this.labelWidget.setText(label.getText());
            }
        }
    }

    protected void widgetDisposed() {
        this.labelProvider.dispose();
    }

    public Control getControl() {
        return this.composite;
    }

    public void setLabelProvider(IViewerLabelProvider lp) {
        if (lp != this.labelProvider) {
            this.labelProvider.dispose();
            this.labelProvider = lp;
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public IStructuredSelection getSelection() {
        return this.selectionProvider.getStructuredSelection();
    }

    public MenuManager getContextMenu() {
        return this.popupMenu;
    }

    public String getText() {
        return this.linkWidget != null ? this.linkWidget.getText() : this.labelWidget.getText();
    }

    private class PrivateInterface
    implements DisposeListener,
    IElementRemovedNotifier,
    ILabelProviderListener,
    Listener {
        private PrivateInterface() {
        }

        public void widgetDisposed(DisposeEvent e) {
            SmartLabel.this.widgetDisposed();
        }

        public void addElementRemovedListener(IElementRemovedListener listener) {
            SmartLabel.this.elementRemovedListeners.add(listener);
        }

        public void fireElementRemoved(Object element) {
        }

        public void removeAllRemoveListeners() {
        }

        public void removeElementRemoveListener(IElementRemovedListener listener) {
            SmartLabel.this.elementRemovedListeners.remove(listener);
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            SmartLabel.this.updateLabel();
        }

        public void handleEvent(Event event) {
            if (SmartLabel.this.partResult != null) {
                SmartLabel.this.partResult.setResult(SmartLabel.this.input);
            }
        }
    }
}

