/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.viewers.ColumnData;
import com.ibm.team.repository.rcp.ui.internal.viewers.PendingNodeSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleTableViewerLabelProvider<R>
extends TypeLabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private final SimpleTableViewer<R> simpleTableViewer;
    private ViewerLabel cachedCellLabel = null;
    private Object cachedElement = null;
    private int cachedColumn = 0;

    SimpleTableViewerLabelProvider(SimpleTableViewer<R> simpleTableViewer) {
        this.simpleTableViewer = simpleTableViewer;
    }

    public String getColumnText(Object element, int columnIndex) {
        ViewerLabel label = this.getViewerLabel(element, columnIndex);
        return label.getText().replace("\r\n", " ").replace('\r', ' ').replace('\n', ' ');
    }

    private ViewerLabel getViewerLabel(Object element, int columnIndex) {
        ColumnData data;
        if (element == PendingNodeSet.PENDING_NODE) {
            return new ViewerLabel(Messages.SimpleTableViewerLabelProvider_2, null);
        }
        Table table = this.simpleTableViewer.tableViewer.getTable();
        if (table.getColumnCount() == 0) {
            data = this.simpleTableViewer.columnData.get(0);
        } else {
            TableColumn column = this.simpleTableViewer.tableViewer.getTable().getColumn(columnIndex);
            data = (ColumnData)column.getData(ColumnData.class.getName());
        }
        if (this.cachedCellLabel != null && element == this.cachedElement && columnIndex == this.cachedColumn) {
            return this.cachedCellLabel;
        }
        ViewerLabel label = new ViewerLabel("", null);
        data.labelProvider.updateLabel(label, element);
        if (this.simpleTableViewer.rowDecorator != null) {
            this.simpleTableViewer.rowDecorator.updateLabel(label, element);
        }
        this.cachedCellLabel = label;
        this.cachedElement = element;
        this.cachedColumn = columnIndex;
        return label;
    }

    public Color getForeground(Object element, int columnIndex) {
        ViewerLabel label = this.getViewerLabel(element, columnIndex);
        return label.getForeground();
    }

    public Color getBackground(Object element, int columnIndex) {
        ViewerLabel label = this.getViewerLabel(element, columnIndex);
        return label.getBackground();
    }

    public Font getFont(Object element, int columnIndex) {
        ViewerLabel label = this.getViewerLabel(element, columnIndex);
        return label.getFont();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ViewerLabel label = this.getViewerLabel(element, columnIndex);
        return label.getImage();
    }

    public void fireChangeEvent(Object[] elements) {
        this.cachedCellLabel = null;
        this.cachedElement = null;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, elements));
    }

    public void fireAllElementsChanged() {
        this.cachedCellLabel = null;
        this.cachedElement = null;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }

    public void updateLabel(ViewerLabel label, Object element) {
        if (element == PendingNodeSet.PENDING_NODE) {
            return;
        }
        if (this.simpleTableViewer.rowDecorator != null) {
            this.simpleTableViewer.rowDecorator.updateLabel(label, element);
        }
    }
}

