/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.InvertableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SetTransformer<K, V>
implements IDynamicFunction<K, V> {
    private InvertableMap<K, V> map = new InvertableMap();
    private Range range = new Range();
    private ISetListener<K> addRemoveListener = new ISetListener<K>(){

        @Override
        public void changed(SetDiff<K> diff) {
            SetTransformer.this.processDiff(diff);
        }
    };
    private ISetWithListeners<K> domain;
    private ChangeListenerList listenerList = new ChangeListenerList();
    private HashSet<K> nullKeys = new HashSet();
    private boolean allocated;
    private boolean isLazy;

    public SetTransformer(ISetWithListeners domain, boolean lazy) {
        this.domain = domain;
        this.isLazy = lazy;
    }

    protected final void setStale(boolean isStale) {
        this.range.publicSetStale(isStale);
    }

    public ISetWithListeners<K> getDomain() {
        return this.domain;
    }

    protected void reportResults(Map<K, V> results) {
        HashSet<V> additions = new HashSet<V>();
        HashSet<V> removals = new HashSet<V>();
        for (Map.Entry<K, V> nextEntry : results.entrySet()) {
            V oldValue;
            K key = nextEntry.getKey();
            V value = nextEntry.getValue();
            if (!this.map.containsKey(key) && !this.nullKeys.contains(key)) continue;
            if (value == null) {
                this.nullKeys.add(key);
                oldValue = this.map.remove(key);
                if (oldValue == null || this.map.containsValue(oldValue)) continue;
                removals.add(oldValue);
                continue;
            }
            this.nullKeys.remove(key);
            if (!this.map.containsValue(value)) {
                additions.add(value);
            }
            if ((oldValue = this.map.put(key, value)) == null || this.map.containsValue(oldValue)) continue;
            removals.add(oldValue);
        }
        HashSet<V> finalRemovals = new HashSet<V>();
        finalRemovals.addAll(removals);
        finalRemovals.removeAll(additions);
        HashSet<V> finalAdditions = new HashSet<V>();
        finalAdditions.addAll(additions);
        finalAdditions.removeAll(removals);
        this.range.doFireDiff(SetDiff.create(finalRemovals, finalAdditions));
        this.listenerList.notifyListeners((Object)this, (Object)results.keySet().toArray());
    }

    @Override
    public final ISetWithListeners<V> getRange() {
        return this.range;
    }

    @Override
    public final V computeResult(K element) {
        if (this.map.containsKey(element)) {
            return this.map.get(element);
        }
        if (this.nullKeys.contains(element)) {
            return null;
        }
        V value = this.doComputeResult(element);
        if (value == null) {
            this.nullKeys.add(element);
        } else {
            boolean wasAdded = !this.map.containsValue(value);
            this.map.put(element, value);
            if (wasAdded) {
                this.range.doFireDiff(SetDiff.createSingletonAddition(value));
            }
        }
        this.elementAdded(element);
        return value;
    }

    protected abstract V doComputeResult(K var1);

    protected void elementAdded(K element) {
    }

    protected void elementRemoved(K element) {
    }

    @Override
    public final Collection<K> getKeysFor(V adapter) {
        return this.map.getKeysFor(adapter);
    }

    protected void deallocate() {
        for (K next : this.map.keySet()) {
            this.elementRemoved(next);
        }
        this.map.clear();
        for (K next : this.nullKeys) {
            this.elementRemoved(next);
        }
        this.nullKeys.clear();
        this.domain.removeListener(this.addRemoveListener);
    }

    @Override
    public void addListener(IChangeListener l) {
        this.listenerList.add(l);
        this.refreshAllocatedState();
    }

    @Override
    public void removeListener(IChangeListener l) {
        this.listenerList.remove(l);
        this.refreshAllocatedState();
    }

    private void refreshAllocatedState() {
        boolean newState;
        boolean bl = newState = !this.listenerList.isEmpty() || this.range.isAllocated();
        if (newState != this.allocated) {
            this.allocated = newState;
            if (this.allocated) {
                this.allocate();
            } else {
                this.deallocate();
            }
        }
    }

    protected void allocate() {
        this.domain.addListener(this.addRemoveListener);
        for (K next : this.domain.toCollection()) {
            this.computeResult(next);
        }
    }

    private void processDiff(SetDiff<K> diff) {
        HashSet<V> actualAdds = new HashSet<V>();
        if (!this.isLazy) {
            for (Object element : diff.getAdditions()) {
                if (this.map.containsKey(element) || this.nullKeys.contains(element)) continue;
                V value = this.doComputeResult(element);
                if (value == null) {
                    this.nullKeys.add(element);
                } else {
                    boolean wasAdded = !this.map.containsValue(value);
                    this.map.put(element, value);
                    if (wasAdded) {
                        actualAdds.add(value);
                    }
                }
                this.elementAdded(element);
            }
        }
        HashSet<V> removedValues = new HashSet<V>();
        for (Object object : diff.getRemovals()) {
            this.nullKeys.remove(object);
            V oldMapping = this.map.remove(object);
            if (oldMapping != null && !this.map.containsValue(oldMapping)) {
                removedValues.add(oldMapping);
            }
            this.elementRemoved(object);
        }
        this.range.fireDiff(SetDiff.create(removedValues, actualAdds));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Range
    extends AbstractSetWithListeners<V> {
        private Range() {
        }

        @Override
        protected Collection<V> computeElements() {
            return SetTransformer.this.map.valueSet();
        }

        public void doFireDiff(SetDiff<V> diff) {
            this.fireDiff(diff);
        }

        public void publicSetStale(boolean isStale) {
            this.setStale(isStale);
        }

        @Override
        protected void allocate() {
            super.allocate();
            SetTransformer.this.refreshAllocatedState();
        }

        @Override
        protected void deallocate() {
            super.deallocate();
            SetTransformer.this.refreshAllocatedState();
        }
    }
}

