/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.query.ILazyUpdatable;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.Query;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryQuery<T>
extends Query<T>
implements ILazyUpdatable {
    private ITeamRepository repository;
    private volatile boolean needsRefresh;
    private boolean allowAutoUpdate = true;
    private boolean isAttached = false;
    private WritableValue dirty;
    private IListener changeListener = new IListener(){

        public void handleEvents(List events) {
            RepositoryQuery.this.update();
        }
    };

    public RepositoryQuery(ITeamRepository repository, IOperationRunner runner) {
        this(Realm.getDefault(), repository, runner);
    }

    public RepositoryQuery(Realm realm, ITeamRepository repository, IOperationRunner runner) {
        super(realm, runner);
        this.repository = repository;
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        this.dirty = new WritableValue(realm);
        this.dirty.setValue((Object)false);
    }

    public final void setAutoUpdate(boolean permitUpdates) {
        this.allowAutoUpdate = permitUpdates;
        if (this.isDirty() && permitUpdates) {
            this.confirmUpdate();
        }
    }

    private boolean isDirty() {
        return (Boolean)this.dirty.getValue();
    }

    @Override
    protected final void flushCache(IProgressMonitor monitor) {
        super.flushCache(null);
        try {
            this.doFlushCache(monitor);
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
        this.needsRefresh = true;
    }

    protected void doFlushCache(IProgressMonitor monitor) throws TeamRepositoryException {
    }

    @Override
    public final List<T> computeResult(IProgressMonitor monitor) throws InvocationTargetException {
        if (this.repository.loggedIn()) {
            try {
                boolean shouldRefresh = this.needsRefresh;
                this.needsRefresh = false;
                List<T> result = this.fetchResult(shouldRefresh, monitor);
                return result;
            }
            catch (ConnectionException e) {
                if (this.repository.loggedIn() && (this.repository.getErrorState() & 1) == 0) {
                    throw new InvocationTargetException(e);
                }
                return Collections.emptyList();
            }
            catch (NotLoggedInException notLoggedInException) {
                return Collections.emptyList();
            }
            catch (TeamRepositoryException e) {
                throw new InvocationTargetException(e);
            }
        }
        return Collections.emptyList();
    }

    protected abstract void attachListeners();

    protected abstract void detachListeners();

    @Override
    public void update() {
        if (this.allowAutoUpdate) {
            super.update();
        } else {
            this.getRealm().asyncExec(new Runnable(){

                public void run() {
                    RepositoryQuery.this.doDetach();
                    RepositoryQuery.this.dirty.setValue((Object)true);
                }
            });
        }
    }

    @Override
    protected final void allocate() {
        if (!this.isDirty()) {
            this.doAttach();
        }
    }

    @Override
    public void refresh() {
        this.getOperationRunner().enqueue(Messages.RepositoryQuery_0, new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                RepositoryQuery.this.flushCache(monitor);
                SWTUtil.greedyExec(RepositoryQuery.this.getRealm(), new Runnable(){

                    public void run() {
                        boolean ranRefresh = false;
                        if (RepositoryQuery.this.dirty.getValue().equals(true)) {
                            RepositoryQuery.this.dirty.setValue((Object)false);
                            if (RepositoryQuery.this.isAllocated()) {
                                ranRefresh = true;
                                RepositoryQuery.this.doAttach();
                            }
                        }
                        if (!ranRefresh) {
                            RepositoryQuery.this.forceUpdate();
                        }
                    }
                });
            }
        });
    }

    private void doAttach() {
        if (this.isAttached) {
            return;
        }
        this.isAttached = true;
        this.attachListeners();
        this.repository.addGenericListener((Object)"state", this.changeListener);
        super.allocate();
    }

    @Override
    protected final void deallocate() {
        this.doDetach();
    }

    private void doDetach() {
        if (!this.isAttached) {
            return;
        }
        this.isAttached = false;
        super.deallocate();
        this.repository.removeGenericListener((Object)"state", this.changeListener);
        this.detachListeners();
    }

    protected final ITeamRepository getRepository() {
        return this.repository;
    }

    protected abstract List<T> fetchResult(boolean var1, IProgressMonitor var2) throws TeamRepositoryException;

    @Override
    public final IObservableValue getDirtyFlag() {
        return this.dirty;
    }

    @Override
    public void confirmUpdate() {
        this.getRealm().asyncExec(new Runnable(){

            public void run() {
                if (RepositoryQuery.this.dirty.getValue().equals(true)) {
                    RepositoryQuery.this.dirty.setValue((Object)false);
                    if (RepositoryQuery.this.isAllocated()) {
                        RepositoryQuery.this.doAttach();
                    }
                }
            }
        });
    }

    public synchronized void dispose() {
        this.doDetach();
        super.dispose();
    }
}

