/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.CachingSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RetryQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query<T>
extends CachingSet<T>
implements IRefreshable {
    private static boolean TRACE_EXECUTE = "true".equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(RepositoryUiPlugin.PLUGIN_ID) + "/trace.query.execute")));
    private Operation queryOperation;
    private Operation refreshOperation;
    private static RetryQueue operations = new RetryQueue(Messages.Query_2, false);
    private IOperationRunner runner = operations;

    public Query(IOperationRunner runner) {
        this(Realm.getDefault(), runner);
    }

    public Query(Realm realm, IOperationRunner runner) {
        super(realm);
        Assert.isNotNull((Object)runner);
        this.setStale(true);
        this.runner = runner;
        this.queryOperation = new Operation(){

            public void run(IProgressMonitor monitor, IStatusCollector status) throws OperationFailedException {
                boolean ranSetContents = false;
                try {
                    try {
                        if (TRACE_EXECUTE) {
                            System.out.println("Computing query: " + Query.this.getName() + " (" + Query.this + ")");
                        }
                        final List result = Query.this.computeResult(monitor);
                        ranSetContents = true;
                        SWTUtil.greedyExec(Query.this.getRealm(), new Runnable(){

                            public void run() {
                                try {
                                    try {
                                        Query.this.setContents(result);
                                    }
                                    catch (RuntimeException e) {
                                        StatusUtil.log((Object)this, (int)4, (String)("Error in query " + Query.this.getClass().getName()), (Throwable)e);
                                        Query.this.setStale(false);
                                    }
                                }
                                finally {
                                    Query.this.setStale(false);
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e.getTargetException()));
                    }
                }
                catch (Throwable throwable) {
                    if (!ranSetContents) {
                        SWTUtil.greedyExec(Query.this.getRealm(), new Runnable(){

                            public void run() {
                                Query.this.setStale(false);
                            }
                        });
                    }
                    throw throwable;
                }
                if (!ranSetContents) {
                    SWTUtil.greedyExec(Query.this.getRealm(), new /* invalid duplicate definition of identical inner class */);
                }
            }
        };
        this.refreshOperation = new Operation(){

            public void run(IProgressMonitor monitor, IStatusCollector status) throws OperationFailedException {
                Query.this.flushCache(monitor);
                Query.this.runner.enqueue(Query.this.getName(), Query.this.queryOperation);
            }
        };
    }

    public abstract String getName();

    @Override
    protected void allocate() {
        this.forceUpdate();
        super.allocate();
    }

    public void update() {
        this.forceUpdate();
    }

    protected final void forceUpdate() {
        if (this.getRealm() == null) {
            return;
        }
        SWTUtil.greedyExec(this.getRealm(), new Runnable(){

            public void run() {
                Query.this.setStale(true);
            }
        });
        this.runner.enqueue(this.getName(), this.queryOperation);
    }

    protected void flushCache(IProgressMonitor monitor) {
    }

    @Override
    public void refresh() {
        if (Display.getCurrent() != null) {
            this.setStale(true);
        } else {
            SWTUtil.greedyExec(this.getRealm(), new Runnable(){

                public void run() {
                    Query.this.setStale(true);
                }
            });
        }
        this.runner.enqueue(this.getName(), this.refreshOperation);
    }

    protected final IOperationRunner getOperationRunner() {
        return this.runner;
    }

    @Override
    public boolean canRefresh() {
        return true;
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        this.setStale(true);
    }

    public abstract List<T> computeResult(IProgressMonitor var1) throws InvocationTargetException;
}

