/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ClassMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;

public final class MixedTypeLabelProvider
extends BaseLabelProvider {
    private Set<IViewerLabelProvider> nestedLabelProviders = new HashSet<IViewerLabelProvider>();
    private ClassMap<IViewerLabelProvider> labelProviderMap = new ClassMap();
    private ILabelProviderListener nestedListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] elements = event.getElements();
            if (elements == null) {
                MixedTypeLabelProvider.this.fireAllElementsChangedEvent();
            } else {
                MixedTypeLabelProvider.this.fireChangeEvent(Arrays.asList(elements));
            }
        }
    };

    public MixedTypeLabelProvider put(Class elementType, IViewerLabelProvider labelProvider) {
        if (this.nestedLabelProviders.add(labelProvider)) {
            labelProvider.addListener(this.nestedListener);
        }
        this.labelProviderMap.put(elementType, labelProvider);
        return this;
    }

    public void updateLabel(ViewerLabel label, Object element) {
        IViewerLabelProvider nestedLabelProvider = this.labelProviderMap.get(element.getClass());
        if (nestedLabelProvider != null) {
            nestedLabelProvider.updateLabel(label, element);
        }
    }

    public void dispose() {
        for (IViewerLabelProvider next : this.nestedLabelProviders) {
            next.removeListener(this.nestedListener);
            next.dispose();
        }
        this.nestedLabelProviders.clear();
        this.labelProviderMap.clear();
        super.dispose();
    }
}

