/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.ui.internal.viewers.ColumnSizing;
import com.ibm.team.repository.rcp.ui.internal.viewers.DelegatingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelComparator;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.TableViewerColumn;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import java.util.Comparator;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelColumn<R>
extends TableViewerColumn<R> {
    private DelegatingLabelProvider labelProvider;
    private String headerText;
    private ImageDescriptor image = null;
    private ColumnSizing size;
    private Comparator<R> comparator;
    private IContributionItem contextMenu = null;
    private IConversion<R, Object> hoverProvider = null;
    private boolean defaultSortOrder;
    private Listener paintListener;
    private Listener eraseListener;

    protected LabelColumn(SimpleTableViewer<R> viewer, String name, ImageDescriptor image, ColumnSizing size, IViewerLabelProvider theLabelProvider) {
        this(viewer, name, image, size, theLabelProvider, false);
    }

    protected LabelColumn(SimpleTableViewer<R> viewer, String name, ImageDescriptor image, ColumnSizing size, IViewerLabelProvider theLabelProvider, boolean invertDefaultSortOrder) {
        this.size = size;
        this.labelProvider = new DelegatingLabelProvider();
        this.labelProvider.setLabelProvider(theLabelProvider);
        this.headerText = name;
        this.image = image;
        this.comparator = new LabelComparator<R>(this.labelProvider);
        this.defaultSortOrder = invertDefaultSortOrder;
        viewer.addColumn(this);
    }

    public LabelColumn(SimpleTableViewer<R> parent, String name, ColumnSizing size, boolean invertDefaultSortOrder) {
        this(parent, name, null, size, LabelColumn.createStandardLabels(parent), invertDefaultSortOrder);
    }

    public LabelColumn(SimpleTableViewer<R> parent, String name, ColumnSizing size) {
        this(parent, name, size, false);
    }

    public LabelColumn(SimpleTableViewer<R> parent, String name, int size, boolean invertDefaultSortOrder) {
        this(parent, name, null, new ColumnSizing().setWidth(size).setMoveable(true), LabelColumn.createStandardLabels(parent), invertDefaultSortOrder);
    }

    public LabelColumn(SimpleTableViewer<R> parent, String name, int size) {
        this(parent, name, size, false);
    }

    public LabelColumn(SimpleTableViewer<R> parent, String name, int size, IViewerLabelProvider labelProvider, boolean invertDefaultSortOrder) {
        this(parent, name, null, new ColumnSizing().setWidth(size).setMoveable(true), labelProvider, invertDefaultSortOrder);
    }

    public LabelColumn(SimpleTableViewer<R> parent, String name, int size, IViewerLabelProvider labelProvider) {
        this(parent, name, size, labelProvider, false);
    }

    static IViewerLabelProvider createStandardLabels(SimpleTableViewer<?> viewer) {
        return LabelProviders.create(viewer.getKnownElements());
    }

    public LabelColumn<R> setLabelProvider(IViewerLabelProvider labelProvider) {
        this.labelProvider.setLabelProvider(labelProvider);
        return this;
    }

    @Override
    public String getHeaderText() {
        return this.headerText;
    }

    @Override
    public IViewerLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public ImageDescriptor getHeaderImage() {
        return this.image;
    }

    @Override
    public Comparator<R> getComparator() {
        return this.comparator;
    }

    public LabelColumn<R> setComparator(Comparator<R> newComparator) {
        this.comparator = newComparator;
        return this;
    }

    public LabelColumn<R> setHoverProvider(IConversion<R, Object> rowToHoverConversion) {
        this.hoverProvider = rowToHoverConversion;
        return this;
    }

    @Override
    public Object getElement(R data) {
        if (this.hoverProvider == null) {
            return super.getElement(data);
        }
        return this.hoverProvider.createAdapter(data);
    }

    @Override
    public IContributionItem getContextMenu() {
        return this.contextMenu;
    }

    @Override
    public ColumnSizing getSizing() {
        return this.size;
    }

    @Override
    public void dispose() {
        this.labelProvider.dispose();
        super.dispose();
    }

    @Override
    public boolean isDefaultSortOrderInverted() {
        return this.defaultSortOrder;
    }

    @Override
    public Listener getEraseListener() {
        return this.eraseListener;
    }

    @Override
    public Listener getPaintListener() {
        return this.paintListener;
    }

    public final void setPaintListener(Listener paintListener) {
        this.paintListener = paintListener;
    }

    public final void setEraseListener(Listener eraseListener) {
        this.eraseListener = eraseListener;
    }
}

