/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class HistoryCombo {
    private static final String PREF_HISTORY = "history";
    private static final int MAX_HISTORY_LENGTH = 10;
    private Combo toWrap;
    private Preferences whereToSave;

    public HistoryCombo(Composite parent, Preferences savedState, boolean autoSelect) {
        this(new Combo(parent, 2052), savedState, autoSelect);
    }

    public HistoryCombo(Combo toWrap, Preferences savedState, boolean autoSelect) {
        this.toWrap = toWrap;
        this.whereToSave = savedState;
        if (savedState != null) {
            this.loadState(toWrap, savedState);
        }
        if (toWrap.getItemCount() > 0 && autoSelect) {
            toWrap.select(0);
        }
    }

    public HistoryCombo(Combo toWrap, Preferences savedState) {
        this(toWrap, savedState, true);
    }

    private void loadState(Combo toWrap, Preferences savedState) {
        ArrayList<String> result = new ArrayList<String>();
        int idx = 0;
        while (true) {
            try {
                if (!savedState.nodeExists(PREF_HISTORY + idx)) break;
                Preferences child = savedState.node(PREF_HISTORY + idx);
                String next = child.get("value", "");
                result.add(next);
            }
            catch (BackingStoreException backingStoreException) {
                break;
            }
            ++idx;
        }
        toWrap.setItems(result.toArray(new String[result.size()]));
    }

    protected void reload() {
        this.loadState(this.toWrap, this.whereToSave);
    }

    public Combo getCombo() {
        return this.toWrap;
    }

    public Control getControl() {
        return this.toWrap;
    }

    public String[] getHistory() {
        return this.toWrap.getItems();
    }

    public void addToHistory(String toAdd, boolean updateControl) {
        String[] items = this.toWrap.getItems();
        ArrayList<String> newItems = new ArrayList<String>();
        newItems.add(toAdd);
        int toCopy = Math.min(items.length, 9);
        int i = 0;
        while (i < toCopy) {
            String next = items[i];
            if (!newItems.contains(next)) {
                newItems.add(next);
            }
            ++i;
        }
        String[] newItemsArray = newItems.toArray(new String[newItems.size()]);
        if (updateControl) {
            this.toWrap.setItems(newItemsArray);
        }
        try {
            this.save(this.whereToSave, newItemsArray);
            this.whereToSave.flush();
        }
        catch (BackingStoreException e) {
            RepositoryUiPlugin.log(e);
        }
    }

    public void addToHistory() {
        this.addToHistory(this.toWrap.getText(), false);
    }

    private void save(Preferences whereToSave, String[] items) throws BackingStoreException {
        Preferences historyNode;
        if (whereToSave.nodeExists(PREF_HISTORY)) {
            historyNode = whereToSave.node(PREF_HISTORY);
            historyNode.removeNode();
        }
        historyNode = whereToSave.node(PREF_HISTORY);
        int i = 0;
        while (i < items.length) {
            String next = items[i];
            Preferences child = whereToSave.node(PREF_HISTORY + i);
            child.put("value", next);
            ++i;
        }
    }
}

