/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredSetWithListeners<T>
extends AbstractSetWithListeners<T> {
    private IFilter filter;
    private ISetWithListeners<T> toFilter;
    private ISetListener<T> listener = new ISetListener<T>(){

        @Override
        public void changed(SetDiff<T> diff) {
            ArrayList addedElements = new ArrayList();
            for (Object next : diff.getAdditions()) {
                if (!FilteredSetWithListeners.this.filter.select(next)) continue;
                addedElements.add(next);
            }
            ArrayList removedElements = new ArrayList();
            for (Object next : diff.getRemovals()) {
                if (!FilteredSetWithListeners.this.filter.select(next)) continue;
                removedElements.add(next);
            }
            FilteredSetWithListeners.this.fireDiff(SetDiff.create(removedElements, addedElements));
        }
    };

    public FilteredSetWithListeners(ISetWithListeners<T> toFilter2, IFilter filter2) {
        super(toFilter2.getRealm());
        this.filter = filter2;
        this.toFilter = toFilter2;
    }

    @Override
    protected void allocate() {
        this.toFilter.addListener(this.listener);
        super.allocate();
    }

    @Override
    protected void deallocate() {
        this.toFilter.removeListener(this.listener);
        super.deallocate();
    }

    @Override
    protected Collection<T> computeElements() {
        ArrayList<T> result = new ArrayList<T>();
        for (T next : this.toFilter.toCollection()) {
            if (!this.filter.select(next)) continue;
            result.add(next);
        }
        return result;
    }

    public static <F, E extends F> FilteredSetWithListeners<E> createTypeFilter(ISetWithListeners<F> toFilter, final Class<E> toAccept) {
        return new FilteredSetWithListeners<F>(toFilter, new IFilter(){

            public boolean select(Object toTest) {
                return toTest != null && toAccept.isAssignableFrom(toTest.getClass());
            }
        });
    }
}

