/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;

public class DelegatingLabelProvider
extends BaseLabelProvider {
    private IViewerLabelProvider realLabelProvider;
    private ILabelProviderListener labelListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            DelegatingLabelProvider.this.rebroadcastChangeEvent(event);
        }
    };

    public DelegatingLabelProvider(IViewerLabelProvider labelProvider) {
        this.realLabelProvider = labelProvider;
    }

    public DelegatingLabelProvider() {
        this.realLabelProvider = null;
    }

    protected void rebroadcastChangeEvent(LabelProviderChangedEvent event) {
        if (event.getElements() == null) {
            this.fireAllElementsChangedEvent();
        } else {
            LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, event.getElements());
            this.fireLabelProviderChangedEvent(newEvent);
        }
    }

    public void updateLabel(ViewerLabel label, Object element) {
        if (this.realLabelProvider != null) {
            this.realLabelProvider.updateLabel(label, element);
        }
    }

    public void setLabelProvider(IViewerLabelProvider labelProvider) {
        IViewerLabelProvider oldLabelProvider = this.realLabelProvider;
        if (labelProvider == oldLabelProvider) {
            return;
        }
        this.realLabelProvider = labelProvider;
        this.fireAllElementsChangedEvent();
        if (oldLabelProvider != null) {
            oldLabelProvider.removeListener(this.labelListener);
            oldLabelProvider.dispose();
        }
        if (this.realLabelProvider != null) {
            this.realLabelProvider.addListener(this.labelListener);
        }
    }

    public void dispose() {
        IViewerLabelProvider oldLabelProvider = this.realLabelProvider;
        if (oldLabelProvider != null) {
            oldLabelProvider.removeListener(this.labelListener);
            oldLabelProvider.dispose();
        }
        super.dispose();
    }
}

