/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.ui.services.IDisposable;

public class ConvertingLabelProvider
extends BaseLabelProvider {
    private IDynamicFunction set;
    private IViewerLabelProvider labelProvider;
    private ILabelProviderListener labelProviderListener;
    private IChangeListener functionListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            Object[] changedElements = (Object[])property;
            ConvertingLabelProvider.this.fireChangeEvent(Arrays.asList(changedElements));
        }
    };

    public ConvertingLabelProvider(IViewerLabelProvider toWrap, IDynamicFunction conversion) {
        this.set = conversion;
        this.labelProvider = toWrap;
        this.labelProviderListener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] changedElements = event.getElements();
                if (changedElements == null) {
                    changedElements = ConvertingLabelProvider.this.set.getRange().toArray();
                }
                HashSet newChangedElements = new HashSet();
                int i = 0;
                while (i < changedElements.length) {
                    Object next = changedElements[i];
                    Collection keys = ConvertingLabelProvider.this.set.getKeysFor(next);
                    if (keys != null) {
                        newChangedElements.addAll(keys);
                    }
                    ++i;
                }
                ConvertingLabelProvider.this.fireChangeEvent(newChangedElements);
            }
        };
        conversion.addListener(this.functionListener);
        this.labelProvider.addListener(this.labelProviderListener);
    }

    public void updateLabel(ViewerLabel label, Object element) {
        Object converted = this.set.computeResult(element);
        if (converted != null) {
            this.labelProvider.updateLabel(label, converted);
        }
    }

    public void dispose() {
        this.set.removeListener(this.functionListener);
        this.labelProvider.removeListener(this.labelProviderListener);
        if (this.set instanceof IDisposable) {
            ((IDisposable)this.set).dispose();
        }
        this.labelProvider.dispose();
        super.dispose();
    }
}

