/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.viewers.ColumnSizing;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingSelectionProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.DelegatingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.EmbeddedMenu;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.IFunctionEvaluator;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IdentityFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.RenamableMenu;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.TableViewerColumn;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.parts.IContextMenuHandler;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConvertColumn<R, C>
extends TableViewerColumn<R> {
    private ImageDescriptor image;
    private String title;
    private Comparator<C> comparator = null;
    private ColumnSizing sizing;
    private IDynamicFunction<R, C> adapter;
    private MenuManager menuManager;
    private Comparator wrapperComparator;
    private Comparator<R> defaultComparator = new Comparator<R>(){

        @Override
        public int compare(R input1, R input2) {
            Object o1 = null;
            Object o2 = null;
            if (input1 != null) {
                o1 = ConvertColumn.this.adapter.computeResult(input1);
            }
            if (input2 != null) {
                o2 = ConvertColumn.this.adapter.computeResult(input2);
            }
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (ConvertColumn.this.comparator != null) {
                return ConvertColumn.this.comparator.compare(o1, o2);
            }
            if (o1 instanceof Comparable) {
                Comparable comparable = (Comparable)o1;
                return comparable.compareTo(o2);
            }
            if (Display.getCurrent() != null) {
                ViewerLabel label1 = new ViewerLabel("", null);
                ConvertColumn.this.labelProvider.updateLabel(label1, input1);
                String label1String = NullUtil.safeString((String)label1.getText());
                ViewerLabel label2 = new ViewerLabel("", null);
                ConvertColumn.this.labelProvider.updateLabel(label2, input2);
                String label2String = NullUtil.safeString((String)label2.getText());
                return label1String.compareTo(label2String);
            }
            return 0;
        }
    };
    private RenamableMenu contributionItem;
    private IViewerLabelProvider labelProvider;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            IStructuredSelection ssel = (IStructuredSelection)selection;
            ConvertColumn.this.updateMenuFromSelection(ssel);
        }
    };
    private DelegatingLabelProvider cellLabelProvider;
    private ISelectionProvider originalSelectionProvider;
    private boolean defaultSortOrder;

    public ConvertColumn(SimpleTableViewer<R> viewer, String _title, ImageDescriptor icon, int size, IDynamicFunction _adapterFactory, IViewerLabelProvider provider, boolean invertInitialSort) {
        IContextMenuHandler cmh = viewer.getContextMenuHandler();
        this.originalSelectionProvider = viewer.getSelectionProvider();
        this.defaultSortOrder = invertInitialSort;
        this.title = _title;
        this.image = icon;
        this.sizing = new ColumnSizing().setWidth(size).setMoveable(true);
        this.adapter = _adapterFactory;
        this.cellLabelProvider = new DelegatingLabelProvider();
        this.labelProvider = new ConvertingLabelProvider(this.cellLabelProvider, _adapterFactory);
        RenamableMenu mainMenu = new RenamableMenu(_title, String.valueOf(_title) + "aeouaoeu");
        this.menuManager = new EmbeddedMenu();
        this.contributionItem = mainMenu;
        this.menuManager.add((IContributionItem)new Separator("additions"));
        this.menuManager.add((IContributionItem)new GroupMarker("additions"));
        this.menuManager.add((IContributionItem)new GroupMarker("additions"));
        this.wrapperComparator = this.defaultComparator;
        mainMenu.add((IContributionItem)this.menuManager);
        if (cmh != null) {
            cmh.registerContextMenu(this.menuManager, new ConvertingSelectionProvider<R, C>(this.originalSelectionProvider, this.adapter));
        }
        this.originalSelectionProvider.addSelectionChangedListener(this.selectionChangedListener);
        this.cellLabelProvider.setLabelProvider(provider);
        if (_adapterFactory instanceof IdentityFunction) {
            this.contributionItem = null;
        }
        viewer.addColumn(this);
    }

    public ConvertColumn(SimpleTableViewer<R> viewer, String title, int size, IDynamicFunction<R, C> conversion, boolean invertDefaultSortOrder) {
        this(viewer, title, null, size, conversion, ConvertColumn.createStandardLabelProvider(conversion.getRange()), invertDefaultSortOrder);
    }

    public ConvertColumn(SimpleTableViewer<R> viewer, String title, int size, IDynamicFunction<R, C> conversion) {
        this(viewer, title, size, conversion, false);
    }

    public ConvertColumn(SimpleTableViewer<R> viewer, final String _title, int size, IOperationRunner backgroundOperationRunner, final IFunctionEvaluator<R, C> evaluator, boolean invertDefaultSortOrder) {
        this(viewer, _title, size, new SlowFunction<R, C>(viewer.getKnownElements(), backgroundOperationRunner, viewer.getDisplay(), true){

            @Override
            protected Map<R, C> doFetch(Collection<R> toFetch, IProgressMonitor reporter) throws OperationFailedException {
                return evaluator.evaluate(toFetch, reporter);
            }

            @Override
            protected String getOperationName() {
                return NLS.bind((String)Messages.ConvertColumn_4, (Object)_title);
            }

            @Override
            protected C getDefaultValue() {
                return null;
            }
        }, invertDefaultSortOrder);
    }

    public ConvertColumn(SimpleTableViewer<R> viewer, String _title, int size, IOperationRunner backgroundOperationRunner, IFunctionEvaluator<R, C> evaluator) {
        this(viewer, _title, size, backgroundOperationRunner, evaluator, false);
    }

    public ConvertColumn(SimpleTableViewer<R> viewer, String _title, int size, IConversion<R, C> _adapterFactory) {
        this(viewer, _title, size, _adapterFactory, false);
    }

    public ConvertColumn(SimpleTableViewer<R> viewer, String _title, int size, IConversion<R, C> _adapterFactory, boolean invertDefaultSort) {
        this(viewer, _title, size, new ConvertingSet<R, C>(viewer.getKnownElements(), _adapterFactory, true), invertDefaultSort);
    }

    private static IViewerLabelProvider createStandardLabelProvider(ISetWithListeners knownElements) {
        return LabelProviders.create(knownElements);
    }

    public ISetWithListeners<C> getKnownElements() {
        return this.adapter.getRange();
    }

    @Override
    public IViewerLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public final ConvertColumn<R, C> setCellLabelProvider(IViewerLabelProvider labelProvider) {
        this.cellLabelProvider.setLabelProvider(labelProvider);
        return this;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    @Override
    public IContributionItem getContextMenu() {
        return this.contributionItem;
    }

    @Override
    public String getHeaderText() {
        return this.title;
    }

    @Override
    public Comparator<R> getComparator() {
        return this.wrapperComparator;
    }

    @Override
    public ImageDescriptor getHeaderImage() {
        return this.image;
    }

    @Override
    public ColumnSizing getSizing() {
        return this.sizing;
    }

    public ConvertColumn<R, C> setCellComparator(Comparator<C> c) {
        this.comparator = c;
        this.wrapperComparator = c == null ? null : this.defaultComparator;
        return this;
    }

    public ConvertColumn<R, C> setRowComparator(Comparator<R> c) {
        this.wrapperComparator = c;
        return this;
    }

    @Override
    public void dispose() {
        this.originalSelectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
        if (this.cellLabelProvider != null) {
            this.cellLabelProvider.dispose();
        }
        this.labelProvider.dispose();
        super.dispose();
    }

    private void updateMenuFromSelection(IStructuredSelection ssel) {
        if (this.contributionItem == null) {
            return;
        }
        if (ssel.size() == 1) {
            ViewerLabel theLabel = new ViewerLabel("", null);
            this.labelProvider.updateLabel(theLabel, ssel.getFirstElement());
            this.contributionItem.setMenuText(theLabel.getText());
        } else {
            this.contributionItem.setMenuText(this.title);
        }
    }

    @Override
    public Object getElement(R data) {
        return this.adapter.computeResult(data);
    }

    @Override
    public boolean isDefaultSortOrderInverted() {
        return this.defaultSortOrder;
    }
}

