/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSetWithListeners<E>
extends AbstractObservableSet
implements ISetWithListeners<E> {
    private boolean allocated = false;

    public AbstractSetWithListeners() {
        super(Realm.getDefault());
        this.checkRealm();
    }

    public AbstractSetWithListeners(Realm realm) {
        super(realm);
        Assert.isNotNull((Object)realm);
    }

    protected abstract Collection<E> computeElements();

    protected final void fireCollectionRemoved(Collection<E> removed) {
        HashSet<E> set = removed instanceof Set ? (HashSet<E>)removed : new HashSet<E>(removed);
        this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), set));
    }

    protected final void fireCollectionAdded(Collection<E> added) {
        HashSet<E> set = added instanceof Set ? (HashSet<E>)added : new HashSet<E>(added);
        this.fireSetChange(Diffs.createSetDiff(set, Collections.emptySet()));
    }

    protected final void fireDiff(SetDiff<E> diff) {
        this.checkRealm();
        this.fireSetChange(Diffs.createSetDiff((Set)diff.getAdditions(), (Set)diff.getRemovals()));
    }

    protected final void fireRemoved(E removed) {
        this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), Collections.singleton(removed)));
    }

    protected final void fireAdded(E added) {
        this.fireSetChange(Diffs.createSetDiff(Collections.singleton(added), Collections.emptySet()));
    }

    @Override
    public final void addListener(ISetListener<E> listener) {
        super.addSetChangeListener(listener);
    }

    @Override
    public void removeListener(ISetListener<E> listener) {
        super.removeSetChangeListener(listener);
    }

    protected final void checkThread() {
        this.checkRealm();
    }

    public synchronized Realm getRealm() {
        return super.getRealm();
    }

    protected void firstListenerAdded() {
        if (!this.isAllocated()) {
            super.firstListenerAdded();
            this.allocate();
        }
    }

    protected void lastListenerRemoved() {
        if (!this.hasListeners() && this.isAllocated()) {
            this.deallocate();
            super.lastListenerRemoved();
        }
    }

    protected void deallocate() {
        this.allocated = false;
    }

    protected void allocate() {
        this.allocated = true;
    }

    protected final boolean isAllocated() {
        this.checkRealm();
        return this.allocated;
    }

    public void setStale(boolean newStale) {
        this.checkRealm();
        if (this.isStale() != newStale) {
            super.setStale(newStale);
            if (!newStale) {
                this.fireStale();
            }
        }
    }

    @Override
    public final Collection<E> toCollection() {
        this.checkRealm();
        return this.computeElements();
    }

    protected Set getWrappedSet() {
        this.checkRealm();
        Collection<E> c = this.computeElements();
        if (c instanceof Set) {
            return (Set)c;
        }
        return new HashSet<E>(c);
    }

    public Object getElementType() {
        return null;
    }
}

