/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public abstract class AbstractSelectionProvider
implements ISelectionProvider {
    private List listeners = new ArrayList();

    protected final void fireSelectionChangedEvent(ISelection newSel) {
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, newSel);
        ISelectionChangedListener[] listenersArray = this.listeners.toArray(new ISelectionChangedListener[this.listeners.size()]);
        int i = 0;
        while (i < listenersArray.length) {
            ISelectionChangedListener next = listenersArray[i];
            try {
                next.selectionChanged(e);
            }
            catch (RuntimeException exc) {
                StatusUtil.log((Object)this, (String)"An unhandled exception occurred in a selection listener. The listener has been removed.", (Throwable)exc);
                this.removeSelectionChangedListener(next);
            }
            ++i;
        }
    }

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners.isEmpty()) {
            this.allocate();
        }
        this.listeners.add(listener);
    }

    protected void allocate() {
    }

    protected void deallocate() {
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.deallocate();
        }
    }

    public void setSelection(ISelection selection) {
    }
}

