/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.StatusCollector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class WorkbenchUtil {
    public static IWorkbenchWindow getWindow(Shell s) {
        while (s.getParent() != null) {
            s = (Shell)s.getParent();
        }
        IWorkbenchWindow myWindow = null;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow window = windows[i];
            if (window.getShell() == s) {
                myWindow = window;
            }
            ++i;
        }
        return myWindow;
    }

    public static IWorkbenchPage getPage(Shell s) {
        IWorkbenchWindow window1;
        IWorkbenchPage result = null;
        IWorkbenchWindow window = WorkbenchUtil.getWindow(s);
        if (window != null) {
            result = window.getActivePage();
        }
        if (result == null && (window1 = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            result = window1.getActivePage();
        }
        if (result == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length && result == null) {
                IWorkbenchWindow window2 = windows[i];
                result = window2.getActivePage();
                ++i;
            }
        }
        return result;
    }

    public static void runBackgroundSave(IProgressMonitor progress, Operation op) throws CoreException {
        WorkbenchUtil.runBackgroundSave(progress, op, Messages.WorkbenchUtil_0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runBackgroundSave(IProgressMonitor progress, final Operation op, String opName) throws CoreException {
        Display display = Display.getCurrent();
        Assert.isNotNull((Object)display, (String)"Must be called from UI thread");
        final Object notifier = new Object();
        final int[] work = new int[2];
        final String[] taskName = new String[2];
        final IStatus[] result = new IStatus[1];
        taskName[1] = "";
        boolean initialized = false;
        String sentTaskName = "";
        String sentSubTaskName = "";
        int sentWork = 0;
        Job newJob = new Job(opName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                block8: {
                    ProgressMonitorWrapper subMonitor = new ProgressMonitorWrapper(monitor){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void beginTask(String name, int totalWork) {
                            if (name == null) {
                                name = "";
                            }
                            super.beginTask(name, totalWork);
                            Object object = notifier;
                            synchronized (object) {
                                work[0] = totalWork;
                                taskName[0] = name;
                                notifier.notify();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void setTaskName(String name) {
                            if (name == null) {
                                name = "";
                            }
                            super.setTaskName(name);
                            Object object = notifier;
                            synchronized (object) {
                                taskName[0] = name;
                                notifier.notify();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void subTask(String name) {
                            if (name == null) {
                                name = "";
                            }
                            super.subTask(name);
                            Object object = notifier;
                            synchronized (object) {
                                taskName[1] = name;
                                notifier.notify();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void worked(int _work) {
                            super.worked(_work);
                            Object object = notifier;
                            synchronized (object) {
                                work[1] = work[1] + _work;
                                notifier.notify();
                            }
                        }
                    };
                    try {
                        try {
                            op.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor, (int)100), new StatusCollector());
                        }
                        catch (OperationFailedException e) {
                            StatusUtil.log((IStatus)e.getStatus());
                            result[0] = e.getReason();
                            monitor.done();
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        monitor.done();
                        throw throwable;
                    }
                    monitor.done();
                }
                Object object = notifier;
                synchronized (object) {
                    notifier.notify();
                }
                return Status.OK_STATUS;
            }
        };
        newJob.setPriority(10);
        newJob.schedule();
        while (newJob.getState() != 0) {
            try {
                String sName;
                String tName;
                int workSum;
                int totalWork;
                while (display.readAndDispatch()) {
                }
                Object object = notifier;
                synchronized (object) {
                    notifier.wait(30L);
                    totalWork = work[0];
                    workSum = work[1];
                    tName = taskName[0];
                    sName = taskName[1];
                }
                if (initialized) {
                    int delta = workSum - sentWork;
                    progress.worked(delta);
                    sentWork += delta;
                    if (!Util.equals((Object)tName, (Object)sentTaskName)) {
                        progress.setTaskName(tName);
                        sentTaskName = tName;
                    }
                    if (!Util.equals((Object)sName, (Object)sentSubTaskName)) {
                        progress.subTask(sName);
                        sentSubTaskName = sName;
                    }
                }
                if (initialized || totalWork == 0 || tName == null) continue;
                initialized = true;
                progress.beginTask(tName, totalWork);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (result[0] != null) {
            throw new CoreException(result[0]);
        }
    }
}

