/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.jface.labelProviders.LabelProviderFactory;
import com.ibm.team.repository.rcp.core.utils.ClassIdentifier;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.EclipseAdapterFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.XMLMemento;

public class PersistableAdapter
extends EclipseAdapterFactory {
    private ClassIdentifier implementationClass;
    private boolean initialized = false;
    private ClassIdentifier adaptableClassId;
    private Method saveMethod;
    private String defaultFactoryId;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getAdapter(final Object adaptableObject, Class adapterType) {
        if (adapterType != IPersistableElement.class) {
            return null;
        }
        if (!this.initialized) {
            try {
                Method theMethod;
                Class arg;
                Class clazz;
                try {
                    clazz = this.implementationClass.loadClass();
                }
                catch (ClassNotFoundException e) {
                    this.log(e);
                    return null;
                }
                try {
                    arg = this.adaptableClassId.loadClass();
                }
                catch (ClassNotFoundException e) {
                    this.log(e);
                    return null;
                }
                try {
                    theMethod = clazz.getMethod("saveState", arg, IMemento.class);
                }
                catch (NoSuchMethodException e) {
                    this.log(e);
                    return null;
                }
                catch (SecurityException e) {
                    this.log(e);
                    return null;
                }
                if (!Modifier.isStatic(theMethod.getModifiers())) {
                    this.log("The saveState method must be static");
                    return null;
                }
                this.saveMethod = theMethod;
            }
            finally {
                this.initialized = true;
            }
        }
        if (this.saveMethod == null) return null;
        return new IPersistableElement(){
            private String savedFactoryId;

            public String getFactoryId() {
                if (this.savedFactoryId == null) {
                    XMLMemento tempMemento = XMLMemento.createWriteRoot((String)"temp");
                    this.saveState((IMemento)tempMemento);
                }
                return this.savedFactoryId;
            }

            public void saveState(IMemento memento) {
                try {
                    this.savedFactoryId = (String)PersistableAdapter.this.saveMethod.invoke(null, adaptableObject, memento);
                    if (this.savedFactoryId == null) {
                        this.savedFactoryId = PersistableAdapter.this.defaultFactoryId;
                    }
                }
                catch (IllegalArgumentException e) {
                    PersistableAdapter.this.log(e);
                }
                catch (IllegalAccessException e) {
                    PersistableAdapter.this.log(e);
                }
                catch (InvocationTargetException e) {
                    PersistableAdapter.this.log(e);
                }
            }
        };
    }

    private void log(Throwable e) {
        StatusUtil.log((Object)this, (Throwable)e);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        String classname = "";
        String id = "";
        if (data instanceof String) {
            classname = (String)data;
        } else if (data instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)data;
            classname = (String)hashtable.get("implementation");
            id = (String)hashtable.get("id");
        }
        if (classname.length() == 0) {
            this.throwException(config, NLS.bind((String)"PersistanceAdapter needs to specify the name of the adapter. Correct usage: '{0}:com.ibm.NameOfAnAdapterImplementation", (Object)LabelProviderFactory.class.getName()));
        }
        this.implementationClass = new ClassIdentifier(config.getNamespace(), classname);
        String adaptableType = config.getAttribute("adaptableType");
        if (adaptableType == null) {
            this.throwException(config, "The adaptableType attribute is missing");
        }
        this.adaptableClassId = new ClassIdentifier(config.getNamespace(), adaptableType);
        if (id.length() == 0) {
            id = adaptableType;
        }
        this.defaultFactoryId = id;
    }

    private void throwException(IConfigurationElement config, String string) throws CoreException {
        throw new CoreException(StatusUtil.newStatus((Object)this, (String)this.formatError(string)));
    }

    private String formatError(String string) {
        return NLS.bind((String)"Error in the PersistanceAdapter declared in plugin {0}: {1}", (Object)this.getConfigurationElement().getNamespace(), (Object)string);
    }

    private void log(String formatError) {
        StatusUtil.log((Object)this, (String)formatError);
    }
}

